/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.packages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.packages.PackageSourcePanel;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PackageErrorsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTriggerName = "";
    private String objectType;
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmGotoSource;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private ToolButton menuGotoSource;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableErrors;
    private JToolBar toolBarIndexes;

    public PackageErrorsPanel(IViewAccesibilities accesibilities, String objectType) {
        this.accesibilities = accesibilities;
        this.objectType = objectType;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableErrors.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableErrors.addColumn((TableColumn)new QueryTableColumn("line", this.stringManager.getString("err-line"), 50));
            this.tableErrors.addColumn((TableColumn)new QueryTableColumn("position", this.stringManager.getString("err-position"), 50));
            this.tableErrors.addColumn((TableColumn)new QueryTableColumn("text", this.stringManager.getString("err-text"), 450));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        SwingUtil.addAction((JComponent)this.tableErrors, (javax.swing.Action)this.cmGotoSource);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableErrors, (JButton)this.buttonActions, this.menuActions, "oracle-package-errors-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("PackageErrorsPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PackageErrorsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableErrors.getQuery().close();
            this.tableErrors.getQuery().setSqlText(Sql.getObjectErrorList());
            this.tableErrors.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableErrors.getQuery().paramByName("object_name").setString(this.currentTriggerName);
            this.tableErrors.getQuery().paramByName("object_type").setString(this.objectType);
            this.tableErrors.getQuery().open();
            if (!this.tableErrors.getQuery().isEmpty()) {
                this.tableErrors.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTriggerName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTriggerName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public Query getQuery() {
        return this.tableErrors.getQuery();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableErrors.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.cmGotoSource = new Action();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.menuGotoSource = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableErrors = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PackageErrorsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmGotoSource.setActionCommandKey("cmGotoSource");
        this.cmGotoSource.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmGotoSource.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/descending.gif"));
        this.cmGotoSource.setText(this.stringManager.getString("cmGotoSource-text"));
        this.cmGotoSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PackageErrorsPanel.this.cmGotoSourceActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                PackageErrorsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableErrors);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.toolBarIndexes.add(this.jSeparator1);
        this.menuGotoSource.setAction((javax.swing.Action)this.cmGotoSource);
        this.menuGotoSource.setHorizontalTextPosition(0);
        this.menuGotoSource.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.menuGotoSource);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
        this.tableErrors.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PackageErrorsPanel.this.tableErrorsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.tableErrors);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmGotoSourceActionPerformed(ActionEvent evt) {
        if (this.tableErrors.getSelectedRow() >= 0) {
            try {
                JTabbedPane tp;
                this.tableErrors.getQuery().getRecord(this.tableErrors.getSelectedRow());
                PackageSourcePanel source = (PackageSourcePanel)SwingUtil.getTabbedPaneComponent(PackageSourcePanel.class, (Component)this);
                if (source != null && (tp = (JTabbedPane)SwingUtil.getOwnerComponent(JTabbedPane.class, (Component)this)) != null) {
                    tp.setSelectedComponent(source);
                    source.gotoPoint(this.tableErrors.getQuery().fieldByName("line").getInteger(), this.tableErrors.getQuery().fieldByName("position").getInteger());
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void tableErrorsMouseClicked(MouseEvent evt) {
        if (this.tableErrors.getSelectedRow() >= 0 && evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmGotoSource.performe();
        }
    }
}

