/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.seq;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.AlterSequenceWizard;
import pl.mpak.orbada.oracle.gui.wizards.CreateSequenceWizard;
import pl.mpak.orbada.oracle.gui.wizards.DropSequenceWizard;
import pl.mpak.orbada.oracle.gui.wizards.RecreateSequenceWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class SequencesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmAlterSequence;
    private Action cmCreateSequence;
    private Action cmDropSequence;
    private Action cmFilter;
    private Action cmRecreateSequence;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuAlterSequence;
    private JMenuItem menuCreateSequence;
    private JMenuItem menuDropSequence;
    private JMenuItem menuRecreateSequence;
    private QueryTableStatusBar statusBarSequences;
    private ViewTable tableSequences;
    private JToolBar toolBar;
    private ToolButton toolButton1;

    public SequencesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableSequences.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("sequence_name", this.stringManager.getString("sequence-name"), 190, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("last_number", this.stringManager.getString("last-value"), 120));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("min_value", this.stringManager.getString("min-value"), 120));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("max_value", this.stringManager.getString("max-value"), 180));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("increment_by", this.stringManager.getString("increment-by"), 120));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("cycle_flag", this.stringManager.getString("cycle-flag"), 30));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("order_flag", this.stringManager.getString("order-flag"), 30));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("cache_size", this.stringManager.getString("cache-size"), 80));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("sequence_name", this.stringManager.getString("sequence-name"), (String[])null));
            def.add(new SqlFilterDefComponent("cycle_flag = 'Y'", this.stringManager.getString("are-cycle-flag")));
            def.add(new SqlFilterDefComponent("order_flag = 'Y'", this.stringManager.getString("are-order-flag")));
            def.add(new SqlFilterDefComponent("nvl( cache_size, 0 ) > 0", this.stringManager.getString("are-cache-size")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-sequences-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableSequences, (JButton)this.buttonActions, this.menuActions, "oracle-sequences-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SequencesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableSequences.getQuery().isActive() && this.tableSequences.getSelectedRow() >= 0) {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                objectName = this.tableSequences.getQuery().fieldByName("sequence_name").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableSequences.getSelectedColumn();
            int index = Math.max(0, this.tableSequences.getSelectedRow());
            this.tableSequences.getQuery().close();
            this.tableSequences.getQuery().setSqlText(Sql.getSequenceList(this.filter.getSqlText()));
            this.tableSequences.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableSequences.getQuery().open();
            if (objectName != null && this.tableSequences.getQuery().locate("sequence_name", new Variant(objectName))) {
                this.tableSequences.changeSelection(this.tableSequences.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableSequences.getQuery().isEmpty()) {
                this.tableSequences.changeSelection(Math.min(index, this.tableSequences.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableSequences.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateSequence = new JMenuItem();
        this.menuAlterSequence = new JMenuItem();
        this.menuRecreateSequence = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropSequence = new JMenuItem();
        this.cmCreateSequence = new Action();
        this.cmAlterSequence = new Action();
        this.cmRecreateSequence = new Action();
        this.cmDropSequence = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableSequences = new ViewTable();
        this.statusBarSequences = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.menuCreateSequence.setAction((javax.swing.Action)this.cmCreateSequence);
        this.menuActions.add(this.menuCreateSequence);
        this.menuAlterSequence.setAction((javax.swing.Action)this.cmAlterSequence);
        this.menuActions.add(this.menuAlterSequence);
        this.menuRecreateSequence.setAction((javax.swing.Action)this.cmRecreateSequence);
        this.menuRecreateSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.menuRecreateSequenceActionPerformed(evt);
            }
        });
        this.menuActions.add(this.menuRecreateSequence);
        this.menuActions.add(this.jSeparator2);
        this.menuDropSequence.setAction((javax.swing.Action)this.cmDropSequence);
        this.menuActions.add(this.menuDropSequence);
        this.cmCreateSequence.setActionCommandKey("cmCreateSequence");
        this.cmCreateSequence.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/sequence.gif"));
        this.cmCreateSequence.setText(this.stringManager.getString("cmCreateSequence-text"));
        this.cmCreateSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmCreateSequenceActionPerformed(evt);
            }
        });
        this.cmAlterSequence.setActionCommandKey("cmAlterSequence");
        this.cmAlterSequence.setText(this.stringManager.getString("cmAlterSequence-text"));
        this.cmAlterSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmAlterSequenceActionPerformed(evt);
            }
        });
        this.cmRecreateSequence.setActionCommandKey("cmRecreateSequence");
        this.cmRecreateSequence.setText(this.stringManager.getString("cmRecreateSequence-text"));
        this.cmDropSequence.setActionCommandKey("cmDropSequence");
        this.cmDropSequence.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropSequence.setText(this.stringManager.getString("cmDropSequence-text"));
        this.cmDropSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmDropSequenceActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SequencesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableSequences);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarSequences.setShowFieldType(false);
        this.statusBarSequences.setShowOpenTime(false);
        this.statusBarSequences.setTable((QueryTable)this.tableSequences);
        this.jPanel1.add((Component)this.statusBarSequences, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolButton1.setAction((javax.swing.Action)this.cmCreateSequence);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableSequences.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    SequencesPanelView.this.setCurrentSchemaName(o.toString());
                    SequencesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmCreateSequenceActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateSequenceWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmAlterSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectedRow() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                String sequenceName = this.tableSequences.getQuery().fieldByName("sequence_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterSequenceWizard(this.getDatabase(), this.currentSchemaName, sequenceName), (boolean)true) != null) {
                    this.refresh(sequenceName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void menuRecreateSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectedRow() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                String sequenceName = this.tableSequences.getQuery().fieldByName("sequence_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RecreateSequenceWizard(this.getDatabase(), this.currentSchemaName, sequenceName), (boolean)true) != null) {
                    this.refresh(sequenceName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmDropSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectedRow() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                String sequenceName = this.tableSequences.getQuery().fieldByName("sequence_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropSequenceWizard(this.getDatabase(), this.currentSchemaName, sequenceName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

