/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.settings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleCompileErrorSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CompileErrorSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkErrorGoToTab;
    private Action cmColorErrorLine;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel panelColorErrorLine;

    public CompileErrorSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(OracleCompileErrorSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkErrorGoToTab.setSelected(this.settings.getValue(OracleCompileErrorSettingsProvider.setOnErrorGoToTab, Boolean.valueOf(true)));
        this.panelColorErrorLine.setBackground(this.settings.getValue(OracleCompileErrorSettingsProvider.setErrorLineColor, SwingUtil.Color.DARKORANGE));
    }

    public void applySettings() {
        this.settings.setValue(OracleCompileErrorSettingsProvider.setOnErrorGoToTab, Boolean.valueOf(this.checkErrorGoToTab.isSelected()));
        this.settings.setValue(OracleCompileErrorSettingsProvider.setErrorLineColor, this.panelColorErrorLine.getBackground());
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void changeDataColor(JPanel panel) {
        Color color = JColorChooser.showDialog(this, this.stringManager.getString("select-color"), panel.getBackground());
        if (color != null) {
            panel.setBackground(color);
        }
    }

    private void initComponents() {
        this.cmColorErrorLine = new Action();
        this.checkErrorGoToTab = new JCheckBox();
        this.panelColorErrorLine = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.cmColorErrorLine.setActionCommandKey("cmColorErrorLine");
        this.cmColorErrorLine.setText(this.stringManager.getString("cmColorErrorLine-text"));
        this.cmColorErrorLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompileErrorSettingsPanel.this.cmColorErrorLineActionPerformed(evt);
            }
        });
        this.checkErrorGoToTab.setSelected(true);
        this.checkErrorGoToTab.setText(this.stringManager.getString("CompileErrorSettingsPanel-checkErrorGotoTab-text"));
        this.panelColorErrorLine.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorErrorLineLayout = new GroupLayout(this.panelColorErrorLine);
        this.panelColorErrorLine.setLayout(panelColorErrorLineLayout);
        panelColorErrorLineLayout.setHorizontalGroup(panelColorErrorLineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 104, Short.MAX_VALUE));
        panelColorErrorLineLayout.setVerticalGroup(panelColorErrorLineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.jButton1.setAction((javax.swing.Action)this.cmColorErrorLine);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setPreferredSize(new Dimension(75, 23));
        this.jLabel1.setText(this.stringManager.getString("CompileErrorSettingsPanel-select-color-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkErrorGoToTab).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorErrorLine, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2).addContainerGap(54, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkErrorGoToTab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.panelColorErrorLine, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addContainerGap(276, Short.MAX_VALUE)));
    }

    private void cmColorErrorLineActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorErrorLine);
    }
}

