/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbmsOutputSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DbmsOutputConnectionSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IApplication application;
    private ISettings settings;
    private Database database;
    private JCheckBox checkOnStartupViewEnable;
    private JCheckBox checkUseGlobalSettings;
    private JLabel labelBufferSize;
    private JLabel labelBufferSizeKB;
    private JLabel labelRefreshInterval;
    private JLabel labelRefreshIntervalSec;
    private JSpinner spinBufferSize;
    private JSpinner spinRefreshInterval;

    public DbmsOutputConnectionSettingsPanel(IApplication application, Database database) {
        this.application = application;
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(this.database.getUserProperties().getProperty("schemaId"), OracleDbmsOutputSettingsProvider.settingsName);
        this.spinBufferSize.setModel(new SpinnerNumberModel(1000, 1, 1000000, 100));
        this.spinRefreshInterval.setModel(new SpinnerNumberModel(5, 1, 1000, 1));
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkUseGlobalSettings.setSelected(this.settings.getValue(OracleDbmsOutputSettingsProvider.setUseGlobalSettings, Boolean.valueOf(true)));
        this.spinBufferSize.setValue(this.settings.getValue(OracleDbmsOutputSettingsProvider.setBufferSize, Long.valueOf(1000L)).intValue());
        this.spinRefreshInterval.setValue(this.settings.getValue(OracleDbmsOutputSettingsProvider.setRefreshInterval, Long.valueOf(5L)).intValue());
        this.checkOnStartupViewEnable.setSelected(this.settings.getValue(OracleDbmsOutputSettingsProvider.setOnStartupViewEnable, Boolean.valueOf(true)));
        this.setControlEnabled();
    }

    public void applySettings() {
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setUseGlobalSettings, Boolean.valueOf(this.checkUseGlobalSettings.isSelected()));
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setBufferSize, Long.valueOf(((Integer)this.spinBufferSize.getValue()).intValue()));
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setRefreshInterval, Long.valueOf(((Integer)this.spinRefreshInterval.getValue()).intValue()));
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setOnStartupViewEnable, Boolean.valueOf(this.checkOnStartupViewEnable.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void setControlEnabled() {
        this.checkOnStartupViewEnable.setEnabled(!this.checkUseGlobalSettings.isSelected());
        this.labelBufferSize.setEnabled(!this.checkUseGlobalSettings.isSelected());
        this.spinBufferSize.setEnabled(!this.checkUseGlobalSettings.isSelected());
        this.labelBufferSizeKB.setEnabled(!this.checkUseGlobalSettings.isSelected());
        this.labelRefreshInterval.setEnabled(!this.checkUseGlobalSettings.isSelected());
        this.spinRefreshInterval.setEnabled(!this.checkUseGlobalSettings.isSelected());
        this.labelRefreshIntervalSec.setEnabled(!this.checkUseGlobalSettings.isSelected());
    }

    private void initComponents() {
        this.labelBufferSize = new JLabel();
        this.spinBufferSize = new JSpinner();
        this.labelBufferSizeKB = new JLabel();
        this.checkOnStartupViewEnable = new JCheckBox();
        this.labelRefreshInterval = new JLabel();
        this.spinRefreshInterval = new JSpinner();
        this.labelRefreshIntervalSec = new JLabel();
        this.checkUseGlobalSettings = new JCheckBox();
        this.labelBufferSize.setText(this.stringManager.getString("DbmsOutputSettingsPanel-buffer-size-dd"));
        this.labelBufferSizeKB.setText(this.stringManager.getString("in-kibi"));
        this.checkOnStartupViewEnable.setText(this.stringManager.getString("DbmsOutputSettingsPanel-checkOnStartupViewEnable-text"));
        this.labelRefreshInterval.setText(this.stringManager.getString("DbmsOutputSettingsPanel-refresh-at-dd"));
        this.labelRefreshIntervalSec.setText(this.stringManager.getString("seconds"));
        this.checkUseGlobalSettings.setText(this.stringManager.getString("checkUseGlobalSettings-text"));
        this.checkUseGlobalSettings.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DbmsOutputConnectionSettingsPanel.this.checkUseGlobalSettingsItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkOnStartupViewEnable).addGroup(layout.createSequentialGroup().addComponent(this.labelBufferSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinBufferSize, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelBufferSizeKB)).addGroup(layout.createSequentialGroup().addComponent(this.labelRefreshInterval).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinRefreshInterval, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelRefreshIntervalSec)).addComponent(this.checkUseGlobalSettings)).addContainerGap(195, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkUseGlobalSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkOnStartupViewEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelBufferSize).addComponent(this.labelBufferSizeKB).addComponent(this.spinBufferSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelRefreshInterval).addComponent(this.labelRefreshIntervalSec).addComponent(this.spinRefreshInterval, -2, -1, -2)).addContainerGap(248, Short.MAX_VALUE)));
    }

    private void checkUseGlobalSettingsItemStateChanged(ItemEvent evt) {
        this.setControlEnabled();
    }
}

