/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.settings;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbmsOutputSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DbmsOutputSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkOnStartupViewEnable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSpinner spinBufferSize;
    private JSpinner spinRefreshInterval;

    public DbmsOutputSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(OracleDbmsOutputSettingsProvider.settingsName);
        this.spinBufferSize.setModel(new SpinnerNumberModel(1000, 1, 1000000, 100));
        this.spinRefreshInterval.setModel(new SpinnerNumberModel(5, 1, 1000, 1));
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.spinBufferSize.setValue(this.settings.getValue(OracleDbmsOutputSettingsProvider.setBufferSize, Long.valueOf(1000L)).intValue());
        this.spinRefreshInterval.setValue(this.settings.getValue(OracleDbmsOutputSettingsProvider.setRefreshInterval, Long.valueOf(5L)).intValue());
        this.checkOnStartupViewEnable.setSelected(this.settings.getValue(OracleDbmsOutputSettingsProvider.setOnStartupViewEnable, Boolean.valueOf(true)));
    }

    public void applySettings() {
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setBufferSize, Long.valueOf(((Integer)this.spinBufferSize.getValue()).intValue()));
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setRefreshInterval, Long.valueOf(((Integer)this.spinRefreshInterval.getValue()).intValue()));
        this.settings.setValue(OracleDbmsOutputSettingsProvider.setOnStartupViewEnable, Boolean.valueOf(this.checkOnStartupViewEnable.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spinBufferSize = new JSpinner();
        this.jLabel2 = new JLabel();
        this.checkOnStartupViewEnable = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.spinRefreshInterval = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel1.setText(this.stringManager.getString("DbmsOutputSettingsPanel-buffer-size-dd"));
        this.jLabel2.setText(this.stringManager.getString("in-kibi"));
        this.checkOnStartupViewEnable.setText(this.stringManager.getString("DbmsOutputSettingsPanel-checkOnStartupViewEnable-text"));
        this.jLabel3.setText(this.stringManager.getString("DbmsOutputSettingsPanel-refresh-at-dd"));
        this.jLabel4.setText(this.stringManager.getString("seconds"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkOnStartupViewEnable).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinBufferSize, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinRefreshInterval, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4))).addContainerGap(221, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkOnStartupViewEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.spinBufferSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.spinRefreshInterval, -2, -1, -2)).addContainerGap(288, Short.MAX_VALUE)));
    }
}

