/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleConnectionSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IApplication application;
    private ISettings settings;
    private Database database;
    private JCheckBox checkEditorHighlightSynonyms;
    private JCheckBox checkResolveTableMetadataProblem;
    private JCheckBox checkUseGlobalSettings;

    public OracleConnectionSettingsPanel(IApplication application, Database database) {
        this.application = application;
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(this.database.getUserProperties().getProperty("schemaId"), OracleSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkUseGlobalSettings.setSelected(this.settings.getValue(OracleSettingsProvider.setUseGlobalSettings, Boolean.valueOf(true)));
        this.checkEditorHighlightSynonyms.setSelected(this.settings.getValue(OracleSettingsProvider.setEditorHighlightSynonyms, Boolean.valueOf(false)));
        this.checkResolveTableMetadataProblem.setSelected(this.settings.getValue(OracleSettingsProvider.setSolveTableMetadataProblem, Boolean.valueOf(false)));
        this.enableControls();
    }

    public void applySettings() {
        this.settings.setValue(OracleSettingsProvider.setUseGlobalSettings, Boolean.valueOf(this.checkUseGlobalSettings.isSelected()));
        this.settings.setValue(OracleSettingsProvider.setEditorHighlightSynonyms, Boolean.valueOf(this.checkEditorHighlightSynonyms.isSelected()));
        this.settings.setValue(OracleSettingsProvider.setSolveTableMetadataProblem, Boolean.valueOf(this.checkResolveTableMetadataProblem.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void enableControls() {
        this.checkEditorHighlightSynonyms.setEnabled(!this.checkUseGlobalSettings.isSelected());
    }

    private void initComponents() {
        this.checkEditorHighlightSynonyms = new JCheckBox();
        this.checkUseGlobalSettings = new JCheckBox();
        this.checkResolveTableMetadataProblem = new JCheckBox();
        this.checkEditorHighlightSynonyms.setText(this.stringManager.getString("checkEditorHighlightSynonyms-text"));
        this.checkUseGlobalSettings.setText(this.stringManager.getString("checkUseGlobalSettings-text"));
        this.checkUseGlobalSettings.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OracleConnectionSettingsPanel.this.checkUseGlobalSettingsItemStateChanged(evt);
            }
        });
        this.checkResolveTableMetadataProblem.setText(this.stringManager.getString("checkSolveTableMetadataProblem-text"));
        this.checkResolveTableMetadataProblem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OracleConnectionSettingsPanel.this.checkResolveTableMetadataProblemItemStateChanged(evt);
            }
        });
        this.checkResolveTableMetadataProblem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OracleConnectionSettingsPanel.this.checkResolveTableMetadataProblemActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkUseGlobalSettings).addComponent(this.checkEditorHighlightSynonyms).addComponent(this.checkResolveTableMetadataProblem)).addContainerGap(23, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkUseGlobalSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkEditorHighlightSynonyms).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkResolveTableMetadataProblem).addContainerGap(255, Short.MAX_VALUE)));
    }

    private void checkUseGlobalSettingsItemStateChanged(ItemEvent evt) {
        this.enableControls();
    }

    private void checkResolveTableMetadataProblemItemStateChanged(ItemEvent evt) {
    }

    private void checkResolveTableMetadataProblemActionPerformed(ActionEvent evt) {
    }
}

