/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.settings;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkEditorHighlightSynonyms;
    private JCheckBox checkMultiExplainPlan;
    private JCheckBox checkPackageTabText;

    public OracleSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(OracleSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkMultiExplainPlan.setSelected(this.settings.getValue(OracleSettingsProvider.setMultiExplainPlan, Boolean.valueOf(false)));
        this.checkPackageTabText.setSelected(this.settings.getValue(OracleSettingsProvider.setPackageTabText, Boolean.valueOf(false)));
        this.checkEditorHighlightSynonyms.setSelected(this.settings.getValue(OracleSettingsProvider.setEditorHighlightSynonyms, Boolean.valueOf(false)));
    }

    public void applySettings() {
        this.settings.setValue(OracleSettingsProvider.setMultiExplainPlan, Boolean.valueOf(this.checkMultiExplainPlan.isSelected()));
        this.settings.setValue(OracleSettingsProvider.setPackageTabText, Boolean.valueOf(this.checkPackageTabText.isSelected()));
        this.settings.setValue(OracleSettingsProvider.setEditorHighlightSynonyms, Boolean.valueOf(this.checkEditorHighlightSynonyms.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.checkMultiExplainPlan = new JCheckBox();
        this.checkPackageTabText = new JCheckBox();
        this.checkEditorHighlightSynonyms = new JCheckBox();
        this.checkMultiExplainPlan.setText(this.stringManager.getString("OracleSettingsPanel-checkMultiExplainPlan-text"));
        this.checkPackageTabText.setText(this.stringManager.getString("OracleSettingsPanel-checkPackageTabText-text"));
        this.checkEditorHighlightSynonyms.setText(this.stringManager.getString("checkEditorHighlightSynonyms-text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkMultiExplainPlan).addComponent(this.checkPackageTabText).addComponent(this.checkEditorHighlightSynonyms)).addContainerGap(69, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkMultiExplainPlan).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPackageTabText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkEditorHighlightSynonyms).addContainerGap(255, Short.MAX_VALUE)));
    }
}

