/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.settings;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TemplatesSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IApplication application;
    private ISettings settings;
    private JComboBox comboFunction;
    private JComboBox comboJavaSource;
    private JComboBox comboObjectType;
    private JComboBox comboObjectTypeBody;
    private JComboBox comboPackage;
    private JComboBox comboPackageBody;
    private JComboBox comboProcedure;
    private JComboBox comboTableType;
    private JComboBox comboTrigger;
    private JComboBox comboVarrayType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;

    public TemplatesSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Query query = InternalDatabase.get().createQuery();
        try {
            ArrayList<String> teplateList = new ArrayList<String>();
            query.setSqlText("select distinct tpl_name\n  from templates\n where (tpl_usr_id = :usr_id or tpl_usr_id is null)\n order by tpl_name");
            query.paramByName("usr_id").setString(this.application.getUserId());
            query.open();
            while (!query.eof()) {
                teplateList.add(query.fieldByName("tpl_name").getString());
                query.next();
            }
            this.comboFunction.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboJavaSource.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboObjectType.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboObjectTypeBody.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboPackage.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboPackageBody.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboProcedure.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboTableType.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboTrigger.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboVarrayType.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.settings = this.application.getSettings(OracleTemplatesSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.comboFunction.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setFunction, "oracle-function"));
        this.comboJavaSource.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setJavaSource, "oracle-java-source"));
        this.comboObjectType.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setObjectType, "oracle-object-type"));
        this.comboObjectTypeBody.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setObjectTypeBody, "oracle-object-type-body"));
        this.comboPackage.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setPackage, "oracle-package"));
        this.comboPackageBody.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setPackageBody, "oracle-package-body"));
        this.comboProcedure.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setProcedure, "oracle-procedure"));
        this.comboTableType.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setTableType, "oracle-table-type"));
        this.comboTrigger.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setTrigger, "oracle-trigger"));
        this.comboVarrayType.setSelectedItem(this.settings.getValue(OracleTemplatesSettingsProvider.setVarrayType, "oracle-varray-type"));
    }

    public void applySettings() {
        this.settings.setValue(OracleTemplatesSettingsProvider.setFunction, this.comboFunction.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setJavaSource, this.comboJavaSource.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setObjectType, this.comboObjectType.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setObjectTypeBody, this.comboObjectTypeBody.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setPackage, this.comboPackage.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setPackageBody, this.comboPackageBody.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setProcedure, this.comboProcedure.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setTableType, this.comboTableType.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setTrigger, this.comboTrigger.getSelectedItem().toString());
        this.settings.setValue(OracleTemplatesSettingsProvider.setVarrayType, this.comboVarrayType.getSelectedItem().toString());
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.comboTrigger = new JComboBox();
        this.jLabel2 = new JLabel();
        this.comboFunction = new JComboBox();
        this.comboProcedure = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.comboPackage = new JComboBox();
        this.jLabel5 = new JLabel();
        this.comboPackageBody = new JComboBox();
        this.jLabel6 = new JLabel();
        this.comboObjectType = new JComboBox();
        this.jLabel7 = new JLabel();
        this.comboObjectTypeBody = new JComboBox();
        this.jLabel8 = new JLabel();
        this.comboTableType = new JComboBox();
        this.jLabel9 = new JLabel();
        this.comboVarrayType = new JComboBox();
        this.jLabel10 = new JLabel();
        this.comboJavaSource = new JComboBox();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("trigger-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("function-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("procedure-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("package-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("package-body-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("object-type-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("object-body-type-dd"));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("table-type-dd"));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText(this.stringManager.getString("varray-type-dd"));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText(this.stringManager.getString("java-source-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTrigger, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboFunction, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboProcedure, 0, 285, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel4, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboPackage, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboPackageBody, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboObjectType, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboObjectTypeBody, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTableType, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboVarrayType, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboJavaSource, 0, 285, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboTrigger, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboFunction, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboProcedure, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboPackage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboPackageBody, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboObjectType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.comboObjectTypeBody, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.comboTableType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.comboVarrayType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.comboJavaSource, -2, -1, -2)).addContainerGap(69, Short.MAX_VALUE)));
    }
}

