/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.tables;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleExceptionTableInfo;
import pl.mpak.orbada.oracle.gui.util.ExceptionTableComboBoxModel;
import pl.mpak.orbada.oracle.gui.wizards.DropConstraintWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateIndexesFromConstraintsWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.EnableAllTableConstraintWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.EnableTableConstraintWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.EnableTableRelatedConstraintWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.AlterTableNullWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintCheckWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintForeignKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintPrimaryKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class TableConstraintsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private boolean exceptInited = false;
    private ToolButton buttonActions;
    private ToolButton buttonDeleteExceptedRecords;
    private ToolButton buttonExceptActions;
    private ToolButton buttonExceptRefresh;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private JCheckBox checkExceptView;
    private JCheckBox checkShowData;
    private Action cmColumnNotNull;
    private Action cmCreateConstraintCheck;
    private Action cmCreateConstraintFK;
    private Action cmCreateConstraintPK;
    private Action cmCreateIndexesFromConstraints;
    private Action cmDeleteExceptedRecords;
    private Action cmDropConstraint;
    private Action cmEnableDisableAll;
    private Action cmEnableDisableRelated;
    private Action cmEnableDisableThis;
    private Action cmExceptRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JComboBox comboExceptionTables;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JPopupMenu menuActions;
    private JMenuItem menuColumnNotNull;
    private JMenuItem menuCreateConstraintCheck;
    private JMenuItem menuCreateConstraintFK;
    private JMenuItem menuCreateConstraintPK;
    private JMenuItem menuCreateIndexesFromConstraints;
    private JMenuItem menuDropConstraint;
    private JMenuItem menuEnableDisable;
    private JMenuItem menuEnableDisableAll;
    private JMenuItem menuEnableDisableRelated;
    private JPopupMenu menuExceptActions;
    private JPanel panelExceptions;
    private JSplitPane split;
    private QueryTableStatusBar statusBarConstraints;
    private QueryTableStatusBar statusBarExceptions;
    private ViewTable tableConstraints;
    private DataTable tableExceptions;
    private JToolBar toolBarConstraints;
    private JToolBar toolBarConstraints1;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;
    private ToolButton toolButton4;
    private ToolButton toolButton5;
    private ToolButton toolButton6;
    private ToolButton toolButton7;

    public TableConstraintsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableConstraints.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableConstraintsPanel.this.tableConstraints.getSelectedRow();
                if (rowIndex >= 0 && TableConstraintsPanel.this.tableConstraints.getQuery().isActive()) {
                    try {
                        TableConstraintsPanel.this.tableConstraints.getQuery().getRecord(rowIndex);
                        if (TableConstraintsPanel.this.checkExceptView.isSelected()) {
                            TableConstraintsPanel.this.checkExceptView.setSelected(false);
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.comboExceptionTables.setModel(new ExceptionTableComboBoxModel(this.getDatabase()));
        this.comboExceptionTables.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof OracleExceptionTableInfo) {
                    OracleExceptionTableInfo info = (OracleExceptionTableInfo)((Object)value);
                    this.setText(SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()));
                }
                return this;
            }
        });
        this.tableConstraints.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("constraint_name", this.stringManager.getString("constraint-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("constraint_type", this.stringManager.getString("constraint-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 120));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("position", this.stringManager.getString("position"), 25));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 60, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("DISABLED")) {
                        ((JLabel)renderer).setForeground(Color.DARK_GRAY);
                    }
                }
            })));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("validated", this.stringManager.getString("validated"), 70, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("VALIDATED")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                    } else if (StringUtil.nvl((String)((String)value), (String)"").equals("NOT VALIDATED")) {
                        ((JLabel)renderer).setForeground(Color.RED);
                    }
                }
            })));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("r_schema_name", this.stringManager.getString("ref-schema-name"), 100));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("r_constraint_name", this.stringManager.getString("ref-constraint-name"), 150));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("delete_rule", this.stringManager.getString("delete-rule"), 70));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("search_condition", this.stringManager.getString("search-condition"), 150));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("generated", this.stringManager.getString("generated"), 100));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("deferrable", this.stringManager.getString("deferrable"), 80));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("cons.constraint_name", this.stringManager.getString("constraint-name"), (String[])null));
            def.add(new SqlFilterDefComponent("decode( cons.constraint_type, 'C', 'Check', 'P', 'Primary Key', 'R', 'Foreign Key', 'U', 'Unique Key', 'V', 'Check on view')", this.stringManager.getString("constraint-type"), new String[]{"", "'Check'", "'Primary Key'", "'Foreign Key'", "'Unique Key'", "'Check on view'"}));
            def.add(new SqlFilterDefComponent("cons.r_owner", this.stringManager.getString("ref-schema-name"), (String[])null));
            def.add(new SqlFilterDefComponent("cons.status = 'DISABLED'", this.stringManager.getString("disabled")));
            def.add(new SqlFilterDefComponent("cons.validated <> 'VALIDATED'", this.stringManager.getString("invalid")));
            def.add(new SqlFilterDefComponent("cons.generated = 'USER NAME'", this.stringManager.getString("only-named")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-table-constraints-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.tableExceptions.getQuery().setDatabase(this.getDatabase());
        this.statusBarExceptions.setTable((QueryTable)this.tableExceptions);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableConstraints, (JButton)this.buttonActions, this.menuActions, "oracle-table-constraints-actions");
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableExceptions, (JButton)this.buttonExceptActions, this.menuExceptActions, "oracle-table-constraint-exceptions-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initExceptionsView() {
        this.exceptInited = true;
        ((ExceptionTableComboBoxModel)this.comboExceptionTables.getModel()).change();
        this.comboExceptionTables.setEnabled(((ExceptionTableComboBoxModel)this.comboExceptionTables.getModel()).getSize() > 0);
        this.cmExceptRefresh.setEnabled(((ExceptionTableComboBoxModel)this.comboExceptionTables.getModel()).getSize() > 0);
        this.checkShowData.setEnabled(((ExceptionTableComboBoxModel)this.comboExceptionTables.getModel()).getSize() > 0);
        this.cmDeleteExceptedRecords.setEnabled(((ExceptionTableComboBoxModel)this.comboExceptionTables.getModel()).getSize() > 0);
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableConstraintsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableConstraints.getQuery().close();
            this.tableConstraints.getQuery().setSqlText(Sql.getConstraintList(this.filter.getSqlText()));
            this.tableConstraints.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableConstraints.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableConstraints.getQuery().open();
            if (!this.tableConstraints.getQuery().isEmpty()) {
                this.tableConstraints.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    private void refreshExceptionsTask() {
        if (this.cmExceptRefresh.isEnabled()) {
            this.cmExceptRefresh.setEnabled(false);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TableConstraintsPanel.this.refreshExceptions();
                }
            });
        }
    }

    public void refreshExceptions() {
        if (this.comboExceptionTables.getSelectedItem() instanceof OracleExceptionTableInfo) {
            try {
                this.tableExceptions.getQuery().close();
                if (this.tableConstraints.getSelectedRow() >= 0) {
                    this.tableConstraints.getQuery().getRecord(this.tableConstraints.getSelectedRow());
                    if (this.checkExceptView.isSelected()) {
                        OracleExceptionTableInfo info = (OracleExceptionTableInfo)((Object)this.comboExceptionTables.getSelectedItem());
                        if (this.checkShowData.isSelected()) {
                            this.tableExceptions.getQuery().setSqlText("select *\n  from " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.currentTableName) + "\n" + " where rowid in (\n" + "       select row_id\n" + "         from " + SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()) + "\n" + "        where owner = :SCHEMA_NAME\n" + "          and table_name = :TABLE_NAME\n" + "          and constraint = :CONSTRAINT_NAME)");
                            this.tableExceptions.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
                            this.tableExceptions.getQuery().paramByName("table_name").setString(this.currentTableName);
                            this.tableExceptions.getQuery().paramByName("constraint_name").setString(this.tableConstraints.getQuery().fieldByName("constraint_name").getString());
                        } else {
                            this.tableExceptions.getQuery().setSqlText("select *\n  from " + SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()) + "\n" + " where owner = :SCHEMA_NAME\n" + "   and table_name = :TABLE_NAME\n" + "   and constraint = :CONSTRAINT_NAME");
                            this.tableExceptions.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
                            this.tableExceptions.getQuery().paramByName("table_name").setString(this.currentTableName);
                            this.tableExceptions.getQuery().paramByName("constraint_name").setString(this.tableConstraints.getQuery().fieldByName("constraint_name").getString());
                        }
                        this.tableExceptions.getQuery().open();
                        if (!this.tableExceptions.getQuery().isEmpty()) {
                            this.tableExceptions.changeSelection(0, 0);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.cmExceptRefresh.setEnabled(true);
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableConstraints.getQuery().close();
        this.tableExceptions.getQuery().close();
        this.accesibilities = null;
    }

    public String getTitle() {
        return this.stringManager.getString("TableConstraintsPanel-title");
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropConstraint = new Action();
        this.cmColumnNotNull = new Action();
        this.cmCreateConstraintCheck = new Action();
        this.cmCreateConstraintFK = new Action();
        this.cmCreateConstraintPK = new Action();
        this.menuActions = new JPopupMenu();
        this.menuColumnNotNull = new JMenuItem();
        this.menuCreateConstraintCheck = new JMenuItem();
        this.menuCreateConstraintFK = new JMenuItem();
        this.menuCreateConstraintPK = new JMenuItem();
        this.menuCreateIndexesFromConstraints = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuEnableDisable = new JMenuItem();
        this.menuEnableDisableAll = new JMenuItem();
        this.menuEnableDisableRelated = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropConstraint = new JMenuItem();
        this.cmEnableDisableAll = new Action();
        this.cmEnableDisableRelated = new Action();
        this.cmEnableDisableThis = new Action();
        this.cmExceptRefresh = new Action();
        this.menuExceptActions = new JPopupMenu();
        this.cmDeleteExceptedRecords = new Action();
        this.cmCreateIndexesFromConstraints = new Action();
        this.split = new JSplitPane();
        this.jPanel5 = new JPanel();
        this.jPanel1 = new JPanel();
        this.toolBarConstraints = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.toolButton7 = new ToolButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.toolButton2 = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.toolButton4 = new ToolButton();
        this.toolButton5 = new ToolButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.toolButton6 = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableConstraints = new ViewTable();
        this.statusBarConstraints = new QueryTableStatusBar();
        this.panelExceptions = new JPanel();
        this.jPanel3 = new JPanel();
        this.toolBarConstraints1 = new JToolBar();
        this.jPanel2 = new JPanel();
        this.checkExceptView = new JCheckBox();
        this.jSeparator6 = new JToolBar.Separator();
        this.buttonExceptRefresh = new ToolButton();
        this.buttonExceptActions = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jPanel4 = new JPanel();
        this.comboExceptionTables = new JComboBox();
        this.checkShowData = new JCheckBox();
        this.jSeparator5 = new JToolBar.Separator();
        this.buttonDeleteExceptedRecords = new ToolButton();
        this.jScrollPane2 = new JScrollPane();
        this.tableExceptions = new DataTable();
        this.statusBarExceptions = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropConstraint.setActionCommandKey("cmDropConstraint");
        this.cmDropConstraint.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropConstraint.setText(this.stringManager.getString("cmDropConstraint-text"));
        this.cmDropConstraint.setTooltip(this.stringManager.getString("cmDropConstraint-hint"));
        this.cmDropConstraint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmDropConstraintActionPerformed(evt);
            }
        });
        this.cmColumnNotNull.setActionCommandKey("cmColumnNotNull");
        this.cmColumnNotNull.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/lock16.gif"));
        this.cmColumnNotNull.setText(this.stringManager.getString("cmColumnNotNull-text"));
        this.cmColumnNotNull.setTooltip(this.stringManager.getString("cmColumnNotNull-hint"));
        this.cmColumnNotNull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmColumnNotNullActionPerformed(evt);
            }
        });
        this.cmCreateConstraintCheck.setActionCommandKey("cmCreateConstraintCheck");
        this.cmCreateConstraintCheck.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/verify_document_16.gif"));
        this.cmCreateConstraintCheck.setText(this.stringManager.getString("cmCreateConstraintCheck-text"));
        this.cmCreateConstraintCheck.setTooltip(this.stringManager.getString("cmCreateConstraintCheck-hint"));
        this.cmCreateConstraintCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateConstraintCheckActionPerformed(evt);
            }
        });
        this.cmCreateConstraintFK.setActionCommandKey("cmCreateConstraintFK");
        this.cmCreateConstraintFK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/foreign_key16.gif"));
        this.cmCreateConstraintFK.setText(this.stringManager.getString("cmCreateConstraintFK-text"));
        this.cmCreateConstraintFK.setTooltip(this.stringManager.getString("cmCreateConstraintFK-hint"));
        this.cmCreateConstraintFK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateConstraintFKActionPerformed(evt);
            }
        });
        this.cmCreateConstraintPK.setActionCommandKey("cmCreateConstraintPK");
        this.cmCreateConstraintPK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/primary_key16.gif"));
        this.cmCreateConstraintPK.setText(this.stringManager.getString("cmCreateConstraintPK-text"));
        this.cmCreateConstraintPK.setTooltip(this.stringManager.getString("cmCreateConstraintPK-hint"));
        this.cmCreateConstraintPK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateConstraintPKActionPerformed(evt);
            }
        });
        this.menuColumnNotNull.setAction((javax.swing.Action)this.cmColumnNotNull);
        this.menuActions.add(this.menuColumnNotNull);
        this.menuCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.menuActions.add(this.menuCreateConstraintCheck);
        this.menuCreateConstraintFK.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.menuActions.add(this.menuCreateConstraintFK);
        this.menuCreateConstraintPK.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.menuActions.add(this.menuCreateConstraintPK);
        this.menuCreateIndexesFromConstraints.setAction((javax.swing.Action)this.cmCreateIndexesFromConstraints);
        this.menuActions.add(this.menuCreateIndexesFromConstraints);
        this.menuActions.add(this.jSeparator2);
        this.menuEnableDisable.setAction((javax.swing.Action)this.cmEnableDisableThis);
        this.menuActions.add(this.menuEnableDisable);
        this.menuEnableDisableAll.setAction((javax.swing.Action)this.cmEnableDisableAll);
        this.menuActions.add(this.menuEnableDisableAll);
        this.menuEnableDisableRelated.setAction((javax.swing.Action)this.cmEnableDisableRelated);
        this.menuActions.add(this.menuEnableDisableRelated);
        this.menuActions.add(this.jSeparator3);
        this.menuDropConstraint.setAction((javax.swing.Action)this.cmDropConstraint);
        this.menuActions.add(this.menuDropConstraint);
        this.cmEnableDisableAll.setActionCommandKey("cmEnableDisableAll");
        this.cmEnableDisableAll.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enable_all.gif"));
        this.cmEnableDisableAll.setText(this.stringManager.getString("cmEnableDisableAll-text"));
        this.cmEnableDisableAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmEnableDisableAllActionPerformed(evt);
            }
        });
        this.cmEnableDisableRelated.setActionCommandKey("cmEnableDisableRelated");
        this.cmEnableDisableRelated.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enable_all.gif"));
        this.cmEnableDisableRelated.setText(this.stringManager.getString("cmEnableDisableRelated-text"));
        this.cmEnableDisableRelated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmEnableDisableRelatedActionPerformed(evt);
            }
        });
        this.cmEnableDisableThis.setActionCommandKey("cmEnableDisableThis");
        this.cmEnableDisableThis.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmEnableDisableThis.setText(this.stringManager.getString("cmEnableDisableThis-text"));
        this.cmEnableDisableThis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmEnableDisableThisActionPerformed(evt);
            }
        });
        this.cmExceptRefresh.setActionCommandKey("cmExceptRefresh");
        this.cmExceptRefresh.setEnabled(false);
        this.cmExceptRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmExceptRefresh.setText(this.stringManager.getString("cmExceptRefresh-text"));
        this.cmExceptRefresh.setTooltip(this.stringManager.getString("cmExceptRefresh-hint"));
        this.cmExceptRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmExceptRefreshActionPerformed(evt);
            }
        });
        this.cmDeleteExceptedRecords.setActionCommandKey("cmDeleteExceptedRecords");
        this.cmDeleteExceptedRecords.setEnabled(false);
        this.cmDeleteExceptedRecords.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDeleteExceptedRecords.setText(this.stringManager.getString("cmDeleteExceptedRecords-text"));
        this.cmDeleteExceptedRecords.setTooltip(this.stringManager.getString("cmDeleteExceptedRecords-hint"));
        this.cmDeleteExceptedRecords.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmDeleteExceptedRecordsActionPerformed(evt);
            }
        });
        this.cmCreateIndexesFromConstraints.setText(this.stringManager.getString("cmCreateIndexesFromConstraints-text"));
        this.cmCreateIndexesFromConstraints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableConstraintsPanel.this.cmCreateIndexesFromConstraintsActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableConstraintsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(300);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarConstraints.setFloatable(false);
        this.toolBarConstraints.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonFilter);
        this.toolBarConstraints.add(this.jSeparator7);
        this.toolButton1.setAction((javax.swing.Action)this.cmEnableDisableThis);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton1);
        this.toolButton7.setAction((javax.swing.Action)this.cmEnableDisableAll);
        this.toolButton7.setHorizontalTextPosition(0);
        this.toolButton7.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton7);
        this.toolBarConstraints.add(this.jSeparator8);
        this.toolButton2.setAction((javax.swing.Action)this.cmColumnNotNull);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton2);
        this.toolButton3.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton3);
        this.toolButton4.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.toolButton4.setHorizontalTextPosition(0);
        this.toolButton4.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton4);
        this.toolButton5.setAction((javax.swing.Action)this.cmCreateConstraintPK);
        this.toolButton5.setHorizontalTextPosition(0);
        this.toolButton5.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton5);
        this.toolBarConstraints.add(this.jSeparator9);
        this.toolButton6.setAction((javax.swing.Action)this.cmDropConstraint);
        this.toolButton6.setHorizontalTextPosition(0);
        this.toolButton6.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.toolButton6);
        this.toolBarConstraints.add(this.jSeparator1);
        this.toolBarConstraints.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarConstraints);
        this.jPanel5.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableConstraints);
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.statusBarConstraints.setShowFieldType(false);
        this.statusBarConstraints.setShowOpenTime(false);
        this.statusBarConstraints.setTable((QueryTable)this.tableConstraints);
        this.jPanel5.add((Component)this.statusBarConstraints, "Last");
        this.split.setTopComponent(this.jPanel5);
        this.panelExceptions.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarConstraints1.setFloatable(false);
        this.toolBarConstraints1.setRollover(true);
        this.jPanel2.setLayout(new FlowLayout(1, 2, 3));
        this.checkExceptView.setText(this.stringManager.getString("checkExceptView-text"));
        this.checkExceptView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TableConstraintsPanel.this.checkExceptViewItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.checkExceptView);
        this.toolBarConstraints1.add(this.jPanel2);
        this.toolBarConstraints1.add(this.jSeparator6);
        this.buttonExceptRefresh.setAction((javax.swing.Action)this.cmExceptRefresh);
        this.buttonExceptRefresh.setHorizontalTextPosition(0);
        this.buttonExceptRefresh.setVerticalTextPosition(3);
        this.toolBarConstraints1.add((Component)this.buttonExceptRefresh);
        this.toolBarConstraints1.add((Component)this.buttonExceptActions);
        this.toolBarConstraints1.add(this.jSeparator4);
        this.jPanel4.setLayout(new FlowLayout(1, 2, 3));
        this.comboExceptionTables.setPreferredSize(new Dimension(150, 22));
        this.jPanel4.add(this.comboExceptionTables);
        this.checkShowData.setSelected(true);
        this.checkShowData.setText(this.stringManager.getString("checkShowData-text"));
        this.checkShowData.setEnabled(false);
        this.checkShowData.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TableConstraintsPanel.this.checkShowDataItemStateChanged(evt);
            }
        });
        this.jPanel4.add(this.checkShowData);
        this.toolBarConstraints1.add(this.jPanel4);
        this.toolBarConstraints1.add(this.jSeparator5);
        this.buttonDeleteExceptedRecords.setAction((javax.swing.Action)this.cmDeleteExceptedRecords);
        this.buttonDeleteExceptedRecords.setHorizontalTextPosition(0);
        this.buttonDeleteExceptedRecords.setVerticalTextPosition(3);
        this.toolBarConstraints1.add((Component)this.buttonDeleteExceptedRecords);
        this.jPanel3.add(this.toolBarConstraints1);
        this.panelExceptions.add((Component)this.jPanel3, "North");
        this.jScrollPane2.setViewportView((Component)this.tableExceptions);
        this.panelExceptions.add((Component)this.jScrollPane2, "Center");
        this.statusBarExceptions.setShowFieldType(false);
        this.statusBarExceptions.setShowOpenTime(false);
        this.panelExceptions.add((Component)this.statusBarExceptions, "Last");
        this.split.setRightComponent(this.panelExceptions);
        this.add((Component)this.split, "Center");
    }

    private void cmCreateConstraintPKActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintPrimaryKeyWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    private void cmCreateConstraintFKActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintForeignKeyWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    private void cmCreateConstraintCheckActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintCheckWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    private void cmColumnNotNullActionPerformed(ActionEvent evt) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterTableNullWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName, null, "MODIFY", null), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    private void cmDropConstraintActionPerformed(ActionEvent evt) {
        if (this.tableConstraints.getSelectedRow() >= 0) {
            try {
                this.tableConstraints.getQuery().getRecord(this.tableConstraints.getSelectedRow());
                String constraintName = this.tableConstraints.getQuery().fieldByName("constraint_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropConstraintWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, constraintName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmEnableDisableAllActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new EnableAllTableConstraintWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmEnableDisableRelatedActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new EnableTableRelatedConstraintWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmEnableDisableThisActionPerformed(ActionEvent evt) {
        if (this.tableConstraints.getSelectedRow() >= 0) {
            try {
                this.tableConstraints.getQuery().getRecord(this.tableConstraints.getSelectedRow());
                String constraintName = this.tableConstraints.getQuery().fieldByName("constraint_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new EnableTableConstraintWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, constraintName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmExceptRefreshActionPerformed(ActionEvent evt) {
        this.refreshExceptions();
    }

    private void checkShowDataItemStateChanged(ItemEvent evt) {
        this.refreshExceptions();
    }

    private void checkExceptViewItemStateChanged(ItemEvent evt) {
        if (!this.exceptInited) {
            this.initExceptionsView();
        }
        if (this.cmExceptRefresh.isEnabled()) {
            this.refreshExceptionsTask();
        }
    }

    private void cmDeleteExceptedRecordsActionPerformed(ActionEvent evt) {
        if (this.comboExceptionTables.getSelectedItem() instanceof OracleExceptionTableInfo) {
            try {
                if (this.tableConstraints.getSelectedRow() >= 0 && this.checkExceptView.isSelected() && MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)this.stringManager.getString("TableConstraintsPanel-delete-excepted-records-q"), (int[])ModalResult.YESNO) == 5) {
                    this.tableConstraints.getQuery().getRecord(this.tableConstraints.getSelectedRow());
                    OracleExceptionTableInfo info = (OracleExceptionTableInfo)((Object)this.comboExceptionTables.getSelectedItem());
                    Command command = this.getDatabase().createCommand();
                    command.setSqlText("delete\n  from " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.currentTableName) + "\n" + " where rowid in (\n" + "       select row_id\n" + "         from " + SQLUtil.createSqlName((String)info.getTableOwner(), (String)info.getName()) + "\n" + "        where owner = :SCHEMA_NAME\n" + "          and table_name = :TABLE_NAME\n" + "          and constraint = :CONSTRAINT_NAME)");
                    command.paramByName("schema_name").setString(this.currentSchemaName);
                    command.paramByName("table_name").setString(this.currentTableName);
                    command.paramByName("constraint_name").setString(this.tableConstraints.getQuery().fieldByName("constraint_name").getString());
                    command.execute();
                    this.refreshExceptions();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateIndexesFromConstraintsActionPerformed(ActionEvent evt) {
        if (this.tableConstraints.getSelectedRow() >= 0) {
            try {
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateIndexesFromConstraintsWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

