/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.util.SourceCreator;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableSourcePanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentObjectName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonRefresh;
    private Action cmRefreshSource;
    private OrbadaSyntaxTextArea syntaxSource;
    private JToolBar toolBarContent;

    public TableSourcePanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String objectName, final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableSourcePanel.this.syntaxSource.setDatabaseObject(TableSourcePanel.this.currentSchemaName, "TABLE", objectName, text);
                TableSourcePanel.this.syntaxSource.getEditorArea().setCaretPosition(0);
            }
        });
    }

    private void init() {
        this.syntaxSource.getStatusBar().addPanel("ddl-status").setText(" ");
        this.syntaxSource.setDatabase(this.getDatabase());
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableSourcePanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableSourcePanel.this.refresh();
            }
        });
    }

    public void refresh() {
        this.requestRefresh = false;
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)this.syntaxSource).getSource(this.currentSchemaName, "TABLE", this.currentObjectName);
        this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(" " + this.currentObjectName);
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
                this.setEditorText(null, "");
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.syntaxSource.setDatabase(null);
        this.syntaxSource = null;
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefreshSource = new Action();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.syntaxSource = new OrbadaSyntaxTextArea();
        this.cmRefreshSource.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshSource.setText(this.stringManager.getString("cmRefreshSource-text"));
        this.cmRefreshSource.setTooltip(this.stringManager.getString("cmRefreshSource-hint"));
        this.cmRefreshSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableSourcePanel.this.cmRefreshSourceActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableSourcePanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefreshSource);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.add((Component)this.toolBarContent, "First");
        this.add((Component)this.syntaxSource, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshSourceActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

