/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.tables;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.TriggerFreezeViewService;
import pl.mpak.orbada.oracle.gui.wizards.EnableTriggerWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateTableTriggerWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateTriggerPKColumnWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.DropTableTriggerWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.EnableAllTableTriggersWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.oracle.syntax.parser.OraclePlSqlStructureParser;
import pl.mpak.orbada.oracle.util.SourceCreator;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.sky.gui.swing.syntax.structure.StructureParser;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class TableTriggersPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ISettings settings;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmCompile;
    private Action cmCreatePKColumnTrigger;
    private Action cmCreateTrigger;
    private Action cmDropTrigger;
    private Action cmEnableAllTriggers;
    private Action cmEnableTrigger;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JPopupMenu menuActions;
    private JMenuItem menuCreatePKColumnTrigger;
    private JMenuItem menuCreateTrigger;
    private JMenuItem menuDropTrigger;
    private JMenuItem menuEnable;
    private JMenuItem menuEnableAll;
    private JSplitPane splitTriggers;
    private QueryTableStatusBar statusBarTriggers;
    private ViewTable tableTriggers;
    private OrbadaSyntaxTextArea textTrigger;
    private JToolBar toolBarTriggers;
    private ToolButton toolButton1;
    private ToolButton toolButton2;
    private ToolButton toolButton3;
    private ToolButton toolButton4;
    private ToolButton toolButton5;

    public TableTriggersPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-table-triggers-panel");
        this.splitTriggers.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTriggers.getDividerLocation())).intValue());
        this.textTrigger.setDatabase(this.getDatabase());
        this.textTrigger.setEditable(false);
        this.textTrigger.setStructureParser((StructureParser)new OraclePlSqlStructureParser());
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            String triggerName;

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableTriggersPanel.this.tableTriggers.getSelectedRow();
                if (rowIndex >= 0 && TableTriggersPanel.this.tableTriggers.getQuery().isActive()) {
                    try {
                        TableTriggersPanel.this.tableTriggers.getQuery().getRecord(rowIndex);
                        if (this.triggerName == null || !this.triggerName.equals(TableTriggersPanel.this.tableTriggers.getQuery().fieldByName("trigger_name").getString())) {
                            this.triggerName = TableTriggersPanel.this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                            TableTriggersPanel.this.updateTriggerBody();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    TableTriggersPanel.this.textTrigger.setText("");
                }
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("schema_name", this.stringManager.getString("schema"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_type", this.stringManager.getString("trigger-type"), 120));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("triggering_event", this.stringManager.getString("triggering-event"), 120));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("enabled", this.stringManager.getString("enabled"), 80, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("DISABLED")) {
                        ((JLabel)renderer).setForeground(Color.DARK_GRAY);
                    }
                }
            })));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 80, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                    } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                        ((JLabel)renderer).setForeground(Color.RED);
                    } else if (StringUtil.nvl((String)((String)value), (String)"").equals("DEBUG")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.NAVY);
                    }
                }
            })));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("allt.trigger_name", this.stringManager.getString("trigger-name"), (String[])null));
            def.add(new SqlFilterDefComponent("allt.status = 'DISABLED'", this.stringManager.getString("disabled")));
            def.add(new SqlFilterDefComponent("allo.status = 'INVALID'", this.stringManager.getString("invalid")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-table-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "oracle-table-triggers-actions");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TableTriggersPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            int column = this.tableTriggers.getSelectedColumn();
            int index = Math.max(0, this.tableTriggers.getSelectedRow());
            String triggerName = null;
            if (this.tableTriggers.getQuery().isActive() && this.tableTriggers.getSelectedRow() >= 0) {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                triggerName = this.tableTriggers.getQuery().fieldByName("TRIGGER_NAME").getString();
            }
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(Sql.getTableTriggerList(this.filter.getSqlText()));
            this.tableTriggers.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableTriggers.getQuery().paramByName("table_name").setString(this.currentTableName);
            this.tableTriggers.getQuery().open();
            if (triggerName != null && this.tableTriggers.getQuery().locate("TRIGGER_NAME", new Variant(triggerName))) {
                this.tableTriggers.changeSelection(this.tableTriggers.getQuery().getCurrentRecord().getIndex(), column);
                this.updateTriggerBody();
            } else if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(Math.min(index, this.tableTriggers.getRowCount() - 1), column);
                this.updateTriggerBody();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void updateTriggerBody() {
        try {
            new SourceCreator(this.getDatabase(), (SyntaxTextArea)this.textTrigger).getSource(this.currentSchemaName, "TRIGGER", this.tableTriggers.getQuery().fieldByName("trigger_name").getString());
        }
        catch (Exception ex) {
            this.textTrigger.setDatabaseObject(null, null, null, "");
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TableTriggersPanel-title");
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.settings.setValue("split-location", Long.valueOf(this.splitTriggers.getDividerLocation()));
        this.settings.store();
        this.tableTriggers.getQuery().close();
        this.textTrigger.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropTrigger = new Action();
        this.menuActions = new JPopupMenu();
        this.menuEnable = new JMenuItem();
        this.menuEnableAll = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuCreateTrigger = new JMenuItem();
        this.menuCreatePKColumnTrigger = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropTrigger = new JMenuItem();
        this.cmCreatePKColumnTrigger = new Action();
        this.cmEnableTrigger = new Action();
        this.cmEnableAllTriggers = new Action();
        this.cmCreateTrigger = new Action();
        this.cmFreezeObject = new Action();
        this.cmCompile = new Action();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.buttonCompile = new ToolButton();
        this.toolButton3 = new ToolButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.toolButton4 = new ToolButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.toolButton2 = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton5 = new ToolButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.splitTriggers = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.statusBarTriggers = new QueryTableStatusBar();
        this.textTrigger = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(this.stringManager.getString("cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(this.stringManager.getString("cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmDropTriggerActionPerformed(evt);
            }
        });
        this.menuEnable.setAction((javax.swing.Action)this.cmEnableTrigger);
        this.menuActions.add(this.menuEnable);
        this.menuEnableAll.setAction((javax.swing.Action)this.cmEnableAllTriggers);
        this.menuActions.add(this.menuEnableAll);
        this.menuActions.add(this.jSeparator2);
        this.menuCreateTrigger.setAction((javax.swing.Action)this.cmCreateTrigger);
        this.menuActions.add(this.menuCreateTrigger);
        this.menuCreatePKColumnTrigger.setAction((javax.swing.Action)this.cmCreatePKColumnTrigger);
        this.menuActions.add(this.menuCreatePKColumnTrigger);
        this.menuActions.add(this.jSeparator3);
        this.menuDropTrigger.setAction((javax.swing.Action)this.cmDropTrigger);
        this.menuActions.add(this.menuDropTrigger);
        this.cmCreatePKColumnTrigger.setActionCommandKey("cmCreatePKColumnTrigger");
        this.cmCreatePKColumnTrigger.setText(this.stringManager.getString("cmCreatePKColumnTrigger-text"));
        this.cmCreatePKColumnTrigger.setTooltip(this.stringManager.getString("cmCreatePKColumnTrigger-hint"));
        this.cmCreatePKColumnTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmCreatePKColumnTriggerActionPerformed(evt);
            }
        });
        this.cmEnableTrigger.setActionCommandKey("cmEnableTrigger");
        this.cmEnableTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmEnableTrigger.setText(this.stringManager.getString("cmEnableTrigger-text"));
        this.cmEnableTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmEnableTriggerActionPerformed(evt);
            }
        });
        this.cmEnableAllTriggers.setActionCommandKey("cmEnableAllTriggers");
        this.cmEnableAllTriggers.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enable_all.gif"));
        this.cmEnableAllTriggers.setText(this.stringManager.getString("cmEnableAllTriggers-text"));
        this.cmEnableAllTriggers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmEnableAllTriggersActionPerformed(evt);
            }
        });
        this.cmCreateTrigger.setActionCommandKey("cmCreateTrigger");
        this.cmCreateTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif"));
        this.cmCreateTrigger.setText(this.stringManager.getString("cmCreateTrigger-text"));
        this.cmCreateTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmCreateTriggerActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmCompile.setText(this.stringManager.getString("cmCompile-text"));
        this.cmCompile.setTooltip(this.stringManager.getString("cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableTriggersPanel.this.cmCompileActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableTriggersPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.toolBarTriggers.add(this.jSeparator4);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonCompile);
        this.toolButton3.setAction((javax.swing.Action)this.cmFreezeObject);
        this.toolButton3.setHorizontalTextPosition(0);
        this.toolButton3.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton3);
        this.toolBarTriggers.add(this.jSeparator6);
        this.toolButton1.setAction((javax.swing.Action)this.cmEnableTrigger);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton1);
        this.toolButton4.setAction((javax.swing.Action)this.cmEnableAllTriggers);
        this.toolButton4.setHorizontalTextPosition(0);
        this.toolButton4.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton4);
        this.toolBarTriggers.add(this.jSeparator5);
        this.toolButton2.setAction((javax.swing.Action)this.cmCreateTrigger);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton2);
        this.toolBarTriggers.add(this.jSeparator1);
        this.toolButton5.setAction((javax.swing.Action)this.cmDropTrigger);
        this.toolButton5.setHorizontalTextPosition(0);
        this.toolButton5.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.toolButton5);
        this.toolBarTriggers.add(this.jSeparator7);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
        this.splitTriggers.setBorder(null);
        this.splitTriggers.setDividerLocation(350);
        this.splitTriggers.setOrientation(0);
        this.splitTriggers.setContinuousLayout(true);
        this.splitTriggers.setOneTouchExpandable(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarTriggers.setShowFieldType(false);
        this.statusBarTriggers.setShowOpenTime(false);
        this.statusBarTriggers.setTable((QueryTable)this.tableTriggers);
        this.jPanel1.add((Component)this.statusBarTriggers, "South");
        this.splitTriggers.setLeftComponent(this.jPanel1);
        this.textTrigger.setPreferredSize(new Dimension(81, 150));
        this.splitTriggers.setRightComponent((Component)this.textTrigger);
        this.add((Component)this.splitTriggers, "Center");
    }

    private void cmDropTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropTableTriggerWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, triggerName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmCreatePKColumnTriggerActionPerformed(ActionEvent evt) {
        try {
            if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTriggerPKColumnWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
                this.refresh();
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmEnableTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new EnableTriggerWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName, triggerName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmEnableAllTriggersActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new EnableAllTableTriggersWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCreateTriggerActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTableTriggerWizard(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                this.accesibilities.createView((ViewProvider)new TriggerFreezeViewService(this.accesibilities, this.currentSchemaName, triggerName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCompileActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                this.getDatabase().executeCommand("ALTER TRIGGER " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)triggerName) + " COMPILE" + (OracleDbInfoProvider.instance.isDebugClauseNeeded(this.getDatabase()) ? " DEBUG" : ""));
                this.refresh();
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

