/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.TableFreezeViewService;
import pl.mpak.orbada.oracle.gui.tables.TableTabbedPane;
import pl.mpak.orbada.oracle.gui.wizards.table.CommentTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CopyTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateExternalTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateNormalTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateTemporaryTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateTriggerPKColumnWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.DropTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.LockTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.RenameTableWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.TruncateTableWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.oracle.services.OracleSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TablesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private ISettings connectionSettings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private boolean refreshing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmComment;
    private Action cmCopyTable;
    private Action cmCreateExternalTable;
    private Action cmCreatePKColumnTrigger;
    private Action cmCreateTable;
    private Action cmCreateTemporaryTable;
    private Action cmDropTable;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmLockTable;
    private Action cmRecordCount;
    private Action cmRefresh;
    private Action cmRenameTable;
    private Action cmSelectSchema;
    private Action cmTruncateTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JPopupMenu menuActions;
    private JMenuItem menuCommentTable;
    private JMenuItem menuCopyTable;
    private JMenuItem menuCreateExternalTable;
    private JMenuItem menuCreatePKColumnTrigger;
    private JMenuItem menuCreateTable;
    private JMenuItem menuCreateTemporaryTable;
    private JMenuItem menuDropTable;
    private JMenuItem menuLockTable;
    private JMenuItem menuRecordCount;
    private JMenuItem menuRenameTable;
    private JMenuItem menuTruncateTable;
    private JPanel panelTables;
    private JSplitPane splitTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableTables;
    private TextArea textRemarks;
    private JToolBar toolBarTables;

    public TablesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TablesPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new TableTabbedPane(this.accesibilities);
        this.splitTables.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tables-panel");
        this.connectionSettings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), OracleSettingsProvider.settingsName);
        this.splitTables.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTables.getDividerLocation())).intValue());
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!TablesPanelView.this.refreshing) {
                    TablesPanelView.this.timer.restart();
                }
            }
        });
        this.tableTables.getQuery().setDatabase(this.getDatabase());
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("remarks", this.stringManager.getString("comment"), 200));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("cluster_name", this.stringManager.getString("cluster-name"), 100));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("tablespace_name", this.stringManager.getString("tablespace-name"), 100));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("temporary", this.stringManager.getString("temporary"), 50));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("cache", this.stringManager.getString("is-cached"), 50));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("table_type", this.stringManager.getString("table-type"), 70));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("tbl.table_name", this.stringManager.getString("table-name"), (String[])null));
        def.add(new SqlFilterDefComponent("tbl.cluster_name", this.stringManager.getString("cluster-name"), (String[])null));
        def.add(new SqlFilterDefComponent("tbl.tablespace_name", this.stringManager.getString("tablespace-name"), (String[])null));
        def.add(new SqlFilterDefComponent("tcm.comments", this.stringManager.getString("comment"), (String[])null));
        def.add(new SqlFilterDefComponent("tbl.temporary = 'Y'", this.stringManager.getString("is-temporary")));
        def.add(new SqlFilterDefComponent("trim(tbl.cache) = 'Y'", this.stringManager.getString("is-cached")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-tables-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTables, (JButton)this.buttonActions, this.menuActions, "oracle-tables-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TablesPanelView.this.tableTables.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String tableName = "";
        int rowIndex = this.tableTables.getSelectedRow();
        if (rowIndex >= 0) {
            try {
                this.tableTables.getQuery().getRecord(rowIndex);
                tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                final String remarks = this.tableTables.getQuery().fieldByName("remarks").getString();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TablesPanelView.this.textRemarks.setText(remarks);
                    }
                });
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        } else {
            this.textRemarks.setText("");
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, tableName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TablesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String tableName = null;
            if (this.tableTables.getQuery().isActive() && this.tableTables.getSelectedRow() >= 0) {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                tableName = this.tableTables.getQuery().fieldByName("TABLE_NAME").getString();
            }
            this.refresh(tableName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String tableName) {
        this.refreshing = true;
        try {
            int column = this.tableTables.getSelectedColumn();
            int index = Math.max(0, this.tableTables.getSelectedRow());
            this.tableTables.getQuery().close();
            this.tableTables.getQuery().setSqlText(Sql.getTableList(this.filter.getSqlText(), this.connectionSettings.getValue(OracleSettingsProvider.setSolveTableMetadataProblem, Boolean.valueOf(false))));
            this.tableTables.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableTables.getQuery().open();
            if (tableName != null && this.tableTables.getQuery().locate("TABLE_NAME", new Variant(tableName))) {
                this.tableTables.changeSelection(this.tableTables.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableTables.getQuery().isEmpty()) {
                this.tableTables.changeSelection(Math.min(index, this.tableTables.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.splitTables.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableTables.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
        this.connectionSettings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmDropTable = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateTable = new JMenuItem();
        this.menuCreateExternalTable = new JMenuItem();
        this.menuCreateTemporaryTable = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuCommentTable = new JMenuItem();
        this.menuRecordCount = new JMenuItem();
        this.menuCreatePKColumnTrigger = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuLockTable = new JMenuItem();
        this.menuRenameTable = new JMenuItem();
        this.menuCopyTable = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.menuTruncateTable = new JMenuItem();
        this.menuDropTable = new JMenuItem();
        this.cmComment = new Action();
        this.cmRecordCount = new Action();
        this.cmCreatePKColumnTrigger = new Action();
        this.cmTruncateTable = new Action();
        this.cmLockTable = new Action();
        this.cmRenameTable = new Action();
        this.cmCopyTable = new Action();
        this.cmFreezeObject = new Action();
        this.cmCreateTable = new Action();
        this.cmCreateExternalTable = new Action();
        this.cmCreateTemporaryTable = new Action();
        this.splitTables = new JSplitPane();
        this.panelTables = new JPanel();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableTables = new ViewTable();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.jScrollPane2 = new JScrollPane();
        this.textRemarks = new TextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropTable.setActionCommandKey("cmDropTable");
        this.cmDropTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTable.setText(this.stringManager.getString("cmDropTable-text"));
        this.cmDropTable.setTooltip(this.stringManager.getString("cmDropTable-hint"));
        this.cmDropTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmDropTableActionPerformed(evt);
            }
        });
        this.menuCreateTable.setAction((javax.swing.Action)this.cmCreateTable);
        this.menuActions.add(this.menuCreateTable);
        this.menuCreateExternalTable.setAction((javax.swing.Action)this.cmCreateExternalTable);
        this.menuActions.add(this.menuCreateExternalTable);
        this.menuCreateTemporaryTable.setAction((javax.swing.Action)this.cmCreateTemporaryTable);
        this.menuActions.add(this.menuCreateTemporaryTable);
        this.menuActions.add(this.jSeparator5);
        this.menuCommentTable.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.menuCommentTable);
        this.menuRecordCount.setAction((javax.swing.Action)this.cmRecordCount);
        this.menuActions.add(this.menuRecordCount);
        this.menuCreatePKColumnTrigger.setAction((javax.swing.Action)this.cmCreatePKColumnTrigger);
        this.menuActions.add(this.menuCreatePKColumnTrigger);
        this.menuActions.add(this.jSeparator3);
        this.menuLockTable.setAction((javax.swing.Action)this.cmLockTable);
        this.menuActions.add(this.menuLockTable);
        this.menuRenameTable.setAction((javax.swing.Action)this.cmRenameTable);
        this.menuActions.add(this.menuRenameTable);
        this.menuCopyTable.setAction((javax.swing.Action)this.cmCopyTable);
        this.menuActions.add(this.menuCopyTable);
        this.menuActions.add(this.jSeparator4);
        this.menuTruncateTable.setAction((javax.swing.Action)this.cmTruncateTable);
        this.menuActions.add(this.menuTruncateTable);
        this.menuDropTable.setAction((javax.swing.Action)this.cmDropTable);
        this.menuActions.add(this.menuDropTable);
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmRecordCount.setActionCommandKey("cmRecordCount");
        this.cmRecordCount.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/counts.gif"));
        this.cmRecordCount.setText(this.stringManager.getString("cmRecordCount-text"));
        this.cmRecordCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmRecordCountActionPerformed(evt);
            }
        });
        this.cmCreatePKColumnTrigger.setActionCommandKey("cmCreatePKColumnTrigger");
        this.cmCreatePKColumnTrigger.setText(this.stringManager.getString("cmCreatePKColumnTrigger-text"));
        this.cmCreatePKColumnTrigger.setTooltip(this.stringManager.getString("cmCreatePKColumnTrigger-hint"));
        this.cmCreatePKColumnTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCreatePKColumnTriggerActionPerformed(evt);
            }
        });
        this.cmTruncateTable.setActionCommandKey("cmTruncateTable");
        this.cmTruncateTable.setText(this.stringManager.getString("cmTruncateTable-text"));
        this.cmTruncateTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmTruncateTableActionPerformed(evt);
            }
        });
        this.cmLockTable.setActionCommandKey("cmLockTable");
        this.cmLockTable.setText(this.stringManager.getString("cmLockTable-text"));
        this.cmLockTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmLockTableActionPerformed(evt);
            }
        });
        this.cmRenameTable.setActionCommandKey("cmRenameTable");
        this.cmRenameTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/rename.gif"));
        this.cmRenameTable.setText(this.stringManager.getString("cmRenameTable-text"));
        this.cmRenameTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmRenameTableActionPerformed(evt);
            }
        });
        this.cmCopyTable.setActionCommandKey("cmCopyTable");
        this.cmCopyTable.setText(this.stringManager.getString("cmCopyTable-text"));
        this.cmCopyTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCopyTableActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCreateTable.setActionCommandKey("cmCreateTable");
        this.cmCreateTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/table.gif"));
        this.cmCreateTable.setText(this.stringManager.getString("cmCreateTable-text"));
        this.cmCreateTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCreateTableActionPerformed(evt);
            }
        });
        this.cmCreateExternalTable.setActionCommandKey("cmCreateExternalTable");
        this.cmCreateExternalTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/table.gif"));
        this.cmCreateExternalTable.setText(this.stringManager.getString("cmCreateExternalTable-text"));
        this.cmCreateExternalTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCreateExternalTableActionPerformed(evt);
            }
        });
        this.cmCreateTemporaryTable.setActionCommandKey("cmCreateTemporaryTable");
        this.cmCreateTemporaryTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/table.gif"));
        this.cmCreateTemporaryTable.setText(this.stringManager.getString("cmCreateTemporaryTable-text"));
        this.cmCreateTemporaryTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmCreateTemporaryTableActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TablesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitTables.setBorder(null);
        this.splitTables.setDividerLocation(200);
        this.splitTables.setContinuousLayout(true);
        this.splitTables.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableTables);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTables);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.jScrollPane2.setPreferredSize(new Dimension(166, 50));
        this.textRemarks.setColumns(20);
        this.textRemarks.setEditable(false);
        this.textRemarks.setLineWrap(true);
        this.textRemarks.setRows(5);
        this.textRemarks.setFocusable(false);
        this.textRemarks.setFont(new Font("Courier New", 0, 11));
        this.jScrollPane2.setViewportView((Component)this.textRemarks);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.splitTables.setLeftComponent(this.panelTables);
        this.add((Component)this.splitTables, "Center");
    }

    private void cmDropTableActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropTableWizard(this.getDatabase(), this.currentSchemaName, this.tableTables.getQuery().fieldByName("table_name").getString()), (boolean)true) != null) {
                    this.refresh(null);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTables.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    TablesPanelView.this.setCurrentSchemaName(o.toString());
                    TablesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableListTask();
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectionModel().getLeadSelectionIndex());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentTableWizard(this.getDatabase(), this.currentSchemaName, tableName), (boolean)true) != null) {
                    this.refresh(tableName);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmRecordCountActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            Query query = this.getDatabase().createQuery();
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String schemaName = this.tableTables.getQuery().fieldByName("schema_name").getString();
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                query.open("select /*+ INDEX_FFS( " + tableName + " ) */ count( 0 ) cnt from " + SQLUtil.createSqlName((String)schemaName, (String)tableName));
                MessageBox.show((Component)this, (String)this.stringManager.getString("record-count"), (String)String.format(this.stringManager.getString("TablesPanelView-record-count-info"), SQLUtil.createSqlName((String)schemaName, (String)tableName), query.fieldByName("cnt").getString()), (int)1, (int)1);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
            finally {
                query.close();
            }
        }
    }

    private void cmCreatePKColumnTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTriggerPKColumnWizard(this.getDatabase(), this.currentSchemaName, tableName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmTruncateTableActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new TruncateTableWizard(this.getDatabase(), this.currentSchemaName, tableName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmLockTableActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new LockTableWizard(this.getDatabase(), this.currentSchemaName, tableName), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmRenameTableActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RenameTableWizard(this.getDatabase(), this.currentSchemaName, tableName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCopyTableActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CopyTableWizard(this.getDatabase(), this.currentSchemaName, tableName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTables.getSelectedRow() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                String tableName = this.tableTables.getQuery().fieldByName("table_name").getString();
                this.accesibilities.createView((ViewProvider)new TableFreezeViewService(this.accesibilities, this.currentSchemaName, tableName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateTableActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateNormalTableWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCreateExternalTableActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateExternalTableWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCreateTemporaryTableActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTemporaryTableWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }
}

