/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.FreezeFactory;
import pl.mpak.orbada.oracle.gui.freezing.FreezeViewService;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.CacheRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class SearchObjectPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private FreezeFactory freezeFactory;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonFilter;
    private ToolButton buttonFreeze;
    private ToolButton buttonRefresh;
    private ToolButton buttonSearch;
    private ToolButton buttonSelectSchema;
    private JCheckBox checkAllSchemas;
    private Action cmCompile;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSearchObject;
    private Action cmSelectSchema;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu menuActions;
    private JPanel panelSearch;
    private QueryTableStatusBar statusBar;
    private ViewTable tableObjects;
    private TextField textSearch;
    private JToolBar toolBar;

    public SearchObjectPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.freezeFactory = new FreezeFactory(accesibilities);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SearchObjectPanelView.this.tableObjects.getSelectedRow() >= 0) {
                    try {
                        SearchObjectPanelView.this.tableObjects.getQuery().getRecord(SearchObjectPanelView.this.tableObjects.getSelectedRow());
                        SearchObjectPanelView.this.cmFreezeObject.setEnabled(SearchObjectPanelView.this.freezeFactory.canCreate(SearchObjectPanelView.this.tableObjects.getQuery().fieldByName("object_type").getString()));
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableObjects.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("schema_name", this.stringManager.getString("schema"), 150));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 150));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 250, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 110, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                    } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                        ((JLabel)renderer).setForeground(Color.RED);
                    }
                }
            })));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("created", this.stringManager.getString("created"), 120));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("object_name", this.stringManager.getString("object-name"), (String[])null));
            def.add(new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), new String[]{"('FUNCTION', 'PROCEDURE', 'TABLE', 'VIEW', 'PACKAGE', 'TYPE')"}));
            def.add(new SqlFilterDefComponent("status", this.stringManager.getString("status"), new String[]{"VALID", "INVALID"}));
            def.add(new SqlFilterDefComponent("status <> 'VALID'", this.stringManager.getString("only-invalid")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-search-objects-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.textSearch.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.tableObjects));
        SwingUtil.addAction((JComponent)this.textSearch, (javax.swing.Action)this.cmSearchObject);
        SwingUtil.addAction((JComponent)this.textSearch, (javax.swing.Action)this.cmFreezeObject);
        SwingUtil.addAction((JComponent)this.tableObjects, (javax.swing.Action)this.cmFreezeObject);
        SwingUtil.addAction((JComponent)this.textSearch, (javax.swing.Action)this.cmCompile);
        SwingUtil.addAction((JComponent)this.tableObjects, (javax.swing.Action)this.cmCompile);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableObjects, (JButton)this.buttonActions, this.menuActions, "oracle-search-objects-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SearchObjectPanelView.this.textSearch.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SearchObjectPanelView.this.refreshTableList();
            }
        });
    }

    private void refreshTableList() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableObjects.getQuery().isActive() && this.tableObjects.getSelectedRow() >= 0) {
                this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
                objectName = this.tableObjects.getQuery().fieldByName("object_name").getString();
            }
            this.refreshTableList(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refreshTableList(String objectName) {
        try {
            int column = this.tableObjects.getSelectedColumn();
            int index = Math.max(0, this.tableObjects.getSelectedRow());
            this.tableObjects.getQuery().close();
            this.tableObjects.getQuery().setSqlText(Sql.getObjectsSearch(this.filter.getSqlText()));
            if (!this.checkAllSchemas.isSelected()) {
                this.tableObjects.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            } else {
                this.tableObjects.getQuery().paramByName("schema_name").clearValue();
            }
            this.tableObjects.getQuery().paramByName("object_name").setString(this.textSearch.getText());
            this.tableObjects.getQuery().open();
            if (objectName != null && this.tableObjects.getQuery().locate("object_name", new Variant(objectName))) {
                this.tableObjects.changeSelection(this.tableObjects.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableObjects.getQuery().isEmpty()) {
                this.tableObjects.changeSelection(Math.min(index, this.tableObjects.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableObjects.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.cmSearchObject = new Action();
        this.cmFreezeObject = new Action();
        this.cmCompile = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableObjects = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.panelSearch = new JPanel();
        this.jLabel1 = new JLabel();
        this.textSearch = new TextField();
        this.checkAllSchemas = new JCheckBox();
        this.buttonSearch = new ToolButton();
        this.buttonFreeze = new ToolButton();
        this.buttonCompile = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchObjectPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchObjectPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchObjectPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmSearchObject.setActionCommandKey("cmSearchObject");
        this.cmSearchObject.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmSearchObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_object16.gif"));
        this.cmSearchObject.setText(this.stringManager.getString("cmSearchObject-text"));
        this.cmSearchObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchObjectPanelView.this.cmSearchObjectActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchObjectPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmCompile.setText(this.stringManager.getString("cmCompile-text"));
        this.cmCompile.setTooltip(this.stringManager.getString("cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchObjectPanelView.this.cmCompileActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SearchObjectPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.tableObjects.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SearchObjectPanelView.this.tableObjectsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.tableObjects);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableObjects);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.toolBar.add(this.jSeparator2);
        this.panelSearch.setLayout(new FlowLayout(0, 2, 3));
        this.jLabel1.setDisplayedMnemonic('S');
        this.jLabel1.setLabelFor((Component)this.textSearch);
        this.jLabel1.setText(this.stringManager.getString("search-dd"));
        this.panelSearch.add(this.jLabel1);
        this.textSearch.setPreferredSize(new Dimension(120, 20));
        this.panelSearch.add((Component)this.textSearch);
        this.checkAllSchemas.setText(this.stringManager.getString("checkAllSchemas-text"));
        this.panelSearch.add(this.checkAllSchemas);
        this.toolBar.add(this.panelSearch);
        this.buttonSearch.setAction((javax.swing.Action)this.cmSearchObject);
        this.buttonSearch.setHorizontalTextPosition(0);
        this.buttonSearch.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSearch);
        this.buttonFreeze.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreeze.setHorizontalTextPosition(0);
        this.buttonFreeze.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFreeze);
        this.buttonFreeze.getAccessibleContext().setAccessibleParent(this.toolBar);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonCompile);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refreshTableList();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableObjects.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    SearchObjectPanelView.this.setCurrentSchemaName(o.toString());
                    SearchObjectPanelView.this.refreshTableList();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmSearchObjectActionPerformed(ActionEvent evt) {
        this.refreshTableList();
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableObjects.getSelectedRow() >= 0) {
            try {
                this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
                String objectName = this.tableObjects.getQuery().fieldByName("object_name").getString();
                String objectType = this.tableObjects.getQuery().fieldByName("object_type").getString();
                FreezeViewService service = this.freezeFactory.createInstance(objectType, this.currentSchemaName, objectName);
                if (service != null) {
                    this.accesibilities.createView((ViewProvider)service);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void tableObjectsMouseClicked(MouseEvent evt) {
        if (this.tableObjects.getSelectedRow() >= 0 && evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmFreezeObject.performe();
        }
    }

    private void cmCompileActionPerformed(ActionEvent evt) {
        if (this.tableObjects.getSelectedRow() >= 0) {
            try {
                CacheRecord cr = this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
                String objectName = this.tableObjects.getQuery().fieldByName("object_name").getString();
                String objectType = this.tableObjects.getQuery().fieldByName("object_type").getString();
                if (StringUtil.anyOfString((String)objectType, (String[])new String[]{"PROCEDURE", "FUNCTION", "PACKAGE", "PACKAGE BODY", "VIEW", "TYPE", "TYPE BODY", "MATERIALIZED VIEW", "JAVA SOURCE"}) >= 0) {
                    if ("PACKAGE BODY".equals(objectType)) {
                        objectType = "PACKAGE";
                    }
                    this.getDatabase().executeCommand("ALTER " + objectType + " " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)objectName) + " COMPILE" + (OracleDbInfoProvider.instance.isDebugClauseNeeded(this.getDatabase()) ? " DEBUG" : ""));
                    this.refreshTableList();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

