/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.trash;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.FlashbackObjectWizard;
import pl.mpak.orbada.oracle.gui.wizards.PurgeObjectWizard;
import pl.mpak.orbada.oracle.gui.wizards.PurgeRecyclebinWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class RecyclebinPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private boolean dbaRole;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmFlashbackObject;
    private Action cmPurgeObject;
    private Action cmPurgeRecyclebin;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuFlashback;
    private JMenuItem menuPurgeObject;
    private JMenuItem menuPurgeRecyclebin;
    private QueryTableStatusBar statusBarSequences;
    private ViewTable tableRecyclebin;
    private JToolBar toolBar;

    public RecyclebinPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.dbaRole = "TRUE".equalsIgnoreCase(this.getDatabase().getUserProperties().getProperty("dba-role", "false"));
        this.tableRecyclebin.getQuery().setDatabase(this.getDatabase());
        try {
            if (this.dbaRole) {
                this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("owner", this.stringManager.getString("schema"), 150));
            }
            this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("obejct-name"), 220));
            this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("original_name", this.stringManager.getString("oryginal-name"), 180, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("type", this.stringManager.getString("object-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)));
            this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("operation", this.stringManager.getString("operation"), 100));
            this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("createtime", this.stringManager.getString("created"), 120));
            this.tableRecyclebin.addColumn((TableColumn)new QueryTableColumn("droptime", this.stringManager.getString("droptime"), 120));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("object_name", this.stringManager.getString("obejct-name"), (String[])null));
            def.add(new SqlFilterDefComponent("original_name", this.stringManager.getString("oryginal-name"), (String[])null));
            def.add(new SqlFilterDefComponent("type", this.stringManager.getString("object-type"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-recyclebin-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableRecyclebin, (JButton)this.buttonActions, this.menuActions, "oracle-recyclebin-actions");
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RecyclebinPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableRecyclebin.getQuery().isActive() && this.tableRecyclebin.getSelectedRow() >= 0) {
                this.tableRecyclebin.getQuery().getRecord(this.tableRecyclebin.getSelectedRow());
                objectName = this.tableRecyclebin.getQuery().fieldByName("object_name").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableRecyclebin.getSelectedColumn();
            int index = Math.max(0, this.tableRecyclebin.getSelectedRow());
            this.tableRecyclebin.getQuery().close();
            if (this.dbaRole) {
                this.tableRecyclebin.getQuery().setSqlText(Sql.getDbaRecyclebinList(this.filter.getSqlText()));
            } else {
                this.tableRecyclebin.getQuery().setSqlText(Sql.getRecyclebinList(this.filter.getSqlText()));
            }
            this.tableRecyclebin.getQuery().open();
            if (objectName != null && this.tableRecyclebin.getQuery().locate("object_name", new Variant(objectName))) {
                this.tableRecyclebin.changeSelection(this.tableRecyclebin.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableRecyclebin.getQuery().isEmpty()) {
                this.tableRecyclebin.changeSelection(Math.min(index, this.tableRecyclebin.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableRecyclebin.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuFlashback = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuPurgeObject = new JMenuItem();
        this.menuPurgeRecyclebin = new JMenuItem();
        this.cmFlashbackObject = new Action();
        this.cmPurgeObject = new Action();
        this.cmPurgeRecyclebin = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableRecyclebin = new ViewTable();
        this.statusBarSequences = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecyclebinPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecyclebinPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuFlashback.setAction((javax.swing.Action)this.cmFlashbackObject);
        this.menuActions.add(this.menuFlashback);
        this.menuActions.add(this.jSeparator2);
        this.menuPurgeObject.setAction((javax.swing.Action)this.cmPurgeObject);
        this.menuActions.add(this.menuPurgeObject);
        this.menuPurgeRecyclebin.setAction((javax.swing.Action)this.cmPurgeRecyclebin);
        this.menuActions.add(this.menuPurgeRecyclebin);
        this.cmFlashbackObject.setActionCommandKey("cmFlashbackObject");
        this.cmFlashbackObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/undo.gif"));
        this.cmFlashbackObject.setText(this.stringManager.getString("cmFlashbackObject-text"));
        this.cmFlashbackObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecyclebinPanelView.this.cmFlashbackObjectActionPerformed(evt);
            }
        });
        this.cmPurgeObject.setActionCommandKey("cmPurgeObject");
        this.cmPurgeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmPurgeObject.setText(this.stringManager.getString("cmPurgeObject-text"));
        this.cmPurgeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecyclebinPanelView.this.cmPurgeObjectActionPerformed(evt);
            }
        });
        this.cmPurgeRecyclebin.setActionCommandKey("cmPurgeRecyclebin");
        this.cmPurgeRecyclebin.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmPurgeRecyclebin.setText(this.stringManager.getString("cmPurgeRecyclebin-text"));
        this.cmPurgeRecyclebin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecyclebinPanelView.this.cmPurgeRecyclebinActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                RecyclebinPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableRecyclebin);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarSequences.setShowFieldType(false);
        this.statusBarSequences.setShowOpenTime(false);
        this.statusBarSequences.setTable((QueryTable)this.tableRecyclebin);
        this.jPanel1.add((Component)this.statusBarSequences, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableRecyclebin.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmFlashbackObjectActionPerformed(ActionEvent evt) {
        if (this.tableRecyclebin.getSelectedRow() >= 0) {
            try {
                this.tableRecyclebin.getQuery().getRecord(this.tableRecyclebin.getSelectedRow());
                if (this.dbaRole) {
                    if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new FlashbackObjectWizard(this.getDatabase(), this.tableRecyclebin.getQuery().fieldByName("owner").getString(), this.tableRecyclebin.getQuery().fieldByName("object_name").getString()), (boolean)true) != null) {
                        this.refresh(null);
                    }
                } else if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new FlashbackObjectWizard(this.getDatabase(), this.tableRecyclebin.getQuery().fieldByName("object_name").getString()), (boolean)true) != null) {
                    this.refresh(null);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmPurgeObjectActionPerformed(ActionEvent evt) {
        if (this.tableRecyclebin.getSelectedRow() >= 0) {
            try {
                this.tableRecyclebin.getQuery().getRecord(this.tableRecyclebin.getSelectedRow());
                if (this.dbaRole) {
                    if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new PurgeObjectWizard(this.getDatabase(), this.tableRecyclebin.getQuery().fieldByName("owner").getString(), this.tableRecyclebin.getQuery().fieldByName("object_name").getString()), (boolean)true) != null) {
                        this.refresh(null);
                    }
                } else if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new PurgeObjectWizard(this.getDatabase(), this.tableRecyclebin.getQuery().fieldByName("object_name").getString()), (boolean)true) != null) {
                    this.refresh(null);
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmPurgeRecyclebinActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new PurgeRecyclebinWizard(this.getDatabase()), (boolean)true) != null) {
            this.refresh(null);
        }
    }
}

