/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.triggers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TriggerColumnsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTriggerName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableColumns;
    private JToolBar toolBarColumns;

    public TriggerColumnsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TriggerColumnsPanel.this.tableColumns.getSelectedRow();
                if (rowIndex >= 0 && TriggerColumnsPanel.this.tableColumns.getQuery().isActive()) {
                    try {
                        TriggerColumnsPanel.this.tableColumns.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableColumns.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("table_owner", this.stringManager.getString("table-schema"), 100));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 100));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_list", this.stringManager.getString("column-list"), 100));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_usage", this.stringManager.getString("column-usage"), 100));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("column_name", this.stringManager.getString("column-name"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-trigger-columns-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableColumns, (JButton)this.buttonActions, this.menuActions, "oracle-trigger-columns-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TriggerColumnsPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TriggerColumnsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String columnName = null;
            this.requestRefresh = false;
            if (this.tableColumns.getQuery().isActive() && this.tableColumns.getSelectedRow() >= 0) {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
            }
            this.tableColumns.getQuery().close();
            this.tableColumns.getQuery().setSqlText(Sql.getTriggerColumnList(this.filter.getSqlText()));
            this.tableColumns.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableColumns.getQuery().paramByName("trigger_name").setString(this.currentTriggerName);
            this.tableColumns.getQuery().open();
            if (!this.tableColumns.getQuery().isEmpty()) {
                if (columnName != null && this.tableColumns.getQuery().locate("column_name", new Variant(columnName))) {
                    this.tableColumns.changeSelection(this.tableColumns.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableColumns.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTriggerName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTriggerName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableColumns.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggerColumnsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggerColumnsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TriggerColumnsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableColumns);
        this.add((Component)this.statusBarColumns, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }
}

