/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.triggers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.TriggerFreezeViewService;
import pl.mpak.orbada.oracle.gui.triggers.TriggerSourcePanel;
import pl.mpak.orbada.oracle.gui.triggers.TriggerTabbedPane;
import pl.mpak.orbada.oracle.gui.wizards.CompileAllObjectsWizard;
import pl.mpak.orbada.oracle.gui.wizards.DropTriggerWizard;
import pl.mpak.orbada.oracle.gui.wizards.EnableTriggerWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateTableTriggerWizard;
import pl.mpak.orbada.oracle.gui.wizards.table.CreateTriggerPKColumnWizard;
import pl.mpak.orbada.oracle.gui.wizards.view.CreateViewTriggerWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TriggersPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private boolean refreshing = false;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCompile;
    private Action cmCompileAll;
    private Action cmCompileAllInvalid;
    private Action cmCreatePKColumnTrigger;
    private Action cmCreateTableTrigger;
    private Action cmCreateViewTrigger;
    private Action cmDropTrigger;
    private Action cmEnableTrigger;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JPopupMenu menuActions;
    private JMenuItem menuCompileAll;
    private JMenuItem menuCompileAllInvalid;
    private JMenuItem menuCreatePKColumnTrigger;
    private JMenuItem menuCreateTableTrigger;
    private JMenuItem menuCreateViewTrigger;
    private JMenuItem menuDropTrigger;
    private JMenuItem menuEnable;
    private JPanel panelTables;
    private JSplitPane splitTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableTriggers;
    private JToolBar toolBarTables;

    public TriggersPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TriggersPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new TriggerTabbedPane(this.accesibilities);
        this.splitTables.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-triggers-panel");
        this.splitTables.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitTables.getDividerLocation())).intValue());
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (!TriggersPanelView.this.refreshing) {
                    TriggerSourcePanel panel = (TriggerSourcePanel)TriggersPanelView.this.tabbedPane.getComponent(TriggerSourcePanel.class);
                    if (panel != null && this.lastIndex != TriggersPanelView.this.tableTriggers.getSelectedRow() && !panel.canClose()) {
                        TriggersPanelView.this.tableTriggers.changeSelection(this.lastIndex, TriggersPanelView.this.tableTriggers.getSelectedColumn());
                        return;
                    }
                    this.lastIndex = TriggersPanelView.this.tableTriggers.getSelectedRow();
                    TriggersPanelView.this.timer.restart();
                }
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("status", this.stringManager.getString("status"), 60, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                    ((JLabel)renderer).setForeground(Color.RED);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("DEBUG")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.NAVY);
                }
            }
        })));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("enabled", this.stringManager.getString("enabled"), 70, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("DISABLED")) {
                    ((JLabel)renderer).setForeground(Color.DARK_GRAY);
                }
            }
        })));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("table_owner", this.stringManager.getString("table-schema"), 100));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 100));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("trigger_type", this.stringManager.getString("trigger-type"), 120));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("triggering_event", this.stringManager.getString("triggeriing-event"), 120));
        this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("created", this.stringManager.getString("created"), 110));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("allt.trigger_name", this.stringManager.getString("trigger-name"), (String[])null));
        def.add(new SqlFilterDefComponent("allt.status = 'DISABLED'", this.stringManager.getString("are-disabled")));
        def.add(new SqlFilterDefComponent("allo.status = 'INVALID'", this.stringManager.getString("invalid")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        SwingUtil.addAction((JComponent)this.tableTriggers, (javax.swing.Action)this.cmCompile);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "oracle-triggers-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TriggersPanelView.this.tableTriggers.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String triggerName = "";
        int rowIndex = this.tableTriggers.getSelectedRow();
        if (rowIndex >= 0 && this.tableTriggers.getQuery().isActive()) {
            try {
                this.tableTriggers.getQuery().getRecord(rowIndex);
                triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, triggerName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TriggersPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String triggerName = null;
            if (this.tableTriggers.getQuery().isActive() && this.tableTriggers.getSelectedRow() >= 0) {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                triggerName = this.tableTriggers.getQuery().fieldByName("TRIGGER_NAME").getString();
            }
            this.refresh(triggerName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String triggerName) {
        this.refreshing = true;
        try {
            int column = this.tableTriggers.getSelectedColumn();
            int index = Math.max(0, this.tableTriggers.getSelectedRow());
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(Sql.getAllTriggerList(this.filter.getSqlText(), OracleDbInfoProvider.instance.getMajorVersion(this.getDatabase())));
            this.tableTriggers.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableTriggers.getQuery().open();
            if (triggerName != null && this.tableTriggers.getQuery().locate("TRIGGER_NAME", new Variant(triggerName))) {
                this.tableTriggers.changeSelection(this.tableTriggers.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(Math.min(index, this.tableTriggers.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.splitTables.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableTriggers.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuEnable = new JMenuItem();
        this.menuCreatePKColumnTrigger = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuCreateTableTrigger = new JMenuItem();
        this.menuCreateViewTrigger = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.menuCompileAll = new JMenuItem();
        this.menuCompileAllInvalid = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuDropTrigger = new JMenuItem();
        this.cmDropTrigger = new Action();
        this.cmCreatePKColumnTrigger = new Action();
        this.cmCompile = new Action();
        this.cmEnableTrigger = new Action();
        this.cmCreateTableTrigger = new Action();
        this.cmFreezeObject = new Action();
        this.cmCreateViewTrigger = new Action();
        this.cmCompileAll = new Action();
        this.cmCompileAllInvalid = new Action();
        this.splitTables = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonCompile = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuEnable.setAction((javax.swing.Action)this.cmEnableTrigger);
        this.menuActions.add(this.menuEnable);
        this.menuCreatePKColumnTrigger.setAction((javax.swing.Action)this.cmCreatePKColumnTrigger);
        this.menuActions.add(this.menuCreatePKColumnTrigger);
        this.menuActions.add(this.jSeparator2);
        this.menuCreateTableTrigger.setAction((javax.swing.Action)this.cmCreateTableTrigger);
        this.menuActions.add(this.menuCreateTableTrigger);
        this.menuCreateViewTrigger.setAction((javax.swing.Action)this.cmCreateViewTrigger);
        this.menuActions.add(this.menuCreateViewTrigger);
        this.menuActions.add(this.jSeparator4);
        this.menuCompileAll.setAction((javax.swing.Action)this.cmCompileAll);
        this.menuActions.add(this.menuCompileAll);
        this.menuCompileAllInvalid.setAction((javax.swing.Action)this.cmCompileAllInvalid);
        this.menuActions.add(this.menuCompileAllInvalid);
        this.menuActions.add(this.jSeparator3);
        this.menuDropTrigger.setAction((javax.swing.Action)this.cmDropTrigger);
        this.menuActions.add(this.menuDropTrigger);
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(this.stringManager.getString("cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(this.stringManager.getString("cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmDropTriggerActionPerformed(evt);
            }
        });
        this.cmCreatePKColumnTrigger.setActionCommandKey("cmCreatePKColumnTrigger");
        this.cmCreatePKColumnTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif"));
        this.cmCreatePKColumnTrigger.setText(this.stringManager.getString("cmCreatePKColumnTrigger-text"));
        this.cmCreatePKColumnTrigger.setTooltip(this.stringManager.getString("cmCreatePKColumnTrigger-hint"));
        this.cmCreatePKColumnTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCreatePKColumnTriggerActionPerformed(evt);
            }
        });
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmCompile.setText(this.stringManager.getString("cmCompile-text"));
        this.cmCompile.setTooltip(this.stringManager.getString("cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCompileActionPerformed(evt);
            }
        });
        this.cmEnableTrigger.setActionCommandKey("cmEnableTrigger");
        this.cmEnableTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmEnableTrigger.setText(this.stringManager.getString("cmEnableTrigger-text"));
        this.cmEnableTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmEnableTriggerActionPerformed(evt);
            }
        });
        this.cmCreateTableTrigger.setActionCommandKey("cmCreateTableTrigger");
        this.cmCreateTableTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif"));
        this.cmCreateTableTrigger.setText(this.stringManager.getString("cmCreateTableTrigger-text"));
        this.cmCreateTableTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCreateTableTriggerActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmCreateViewTrigger.setActionCommandKey("cmCreateViewTrigger");
        this.cmCreateViewTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trigger.gif"));
        this.cmCreateViewTrigger.setText(this.stringManager.getString("cmCreateViewTrigger-text"));
        this.cmCreateViewTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCreateViewTriggerActionPerformed(evt);
            }
        });
        this.cmCompileAll.setActionCommandKey("cmCompileAll");
        this.cmCompileAll.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute_all.gif"));
        this.cmCompileAll.setText(this.stringManager.getString("cmCompileAll-text"));
        this.cmCompileAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCompileAllActionPerformed(evt);
            }
        });
        this.cmCompileAllInvalid.setActionCommandKey("cmCompileAllInvalid");
        this.cmCompileAllInvalid.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute_all_invalid.gif"));
        this.cmCompileAllInvalid.setText(this.stringManager.getString("cmCompileAllInvalid-text"));
        this.cmCompileAllInvalid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TriggersPanelView.this.cmCompileAllInvalidActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TriggersPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitTables.setBorder(null);
        this.splitTables.setDividerLocation(200);
        this.splitTables.setContinuousLayout(true);
        this.splitTables.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonCompile);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTriggers);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.splitTables.setLeftComponent(this.panelTables);
        this.add((Component)this.splitTables, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTriggers.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    TriggersPanelView.this.setCurrentSchemaName(o.toString());
                    TriggersPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmDropTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropTriggerWizard(this.getDatabase(), this.currentSchemaName, triggerName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmCreatePKColumnTriggerActionPerformed(ActionEvent evt) {
        try {
            if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTriggerPKColumnWizard(this.getDatabase(), this.currentSchemaName, null), (boolean)true) != null) {
                this.refresh();
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmCompileActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                this.getDatabase().executeCommand("ALTER TRIGGER " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)triggerName) + " COMPILE" + (OracleDbInfoProvider.instance.isDebugClauseNeeded(this.getDatabase()) ? " DEBUG" : ""));
                this.refresh();
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmEnableTriggerActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new EnableTriggerWizard(this.getDatabase(), this.currentSchemaName, null, triggerName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmCreateTableTriggerActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTableTriggerWizard(this.getDatabase(), this.currentSchemaName, null), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTriggers.getSelectedRow() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectedRow());
                String triggerName = this.tableTriggers.getQuery().fieldByName("trigger_name").getString();
                this.accesibilities.createView((ViewProvider)new TriggerFreezeViewService(this.accesibilities, this.currentSchemaName, triggerName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCreateViewTriggerActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateViewTriggerWizard(this.getDatabase(), this.currentSchemaName, null), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCompileAllActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompileAllObjectsWizard(this.getDatabase(), this.currentSchemaName, "TRIGGER", null), (boolean)true);
    }

    private void cmCompileAllInvalidActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompileAllObjectsWizard(this.getDatabase(), this.currentSchemaName, "TRIGGER", "INVALID"), (boolean)true);
    }
}

