/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.types;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.types.cm.PageDownAction;
import pl.mpak.orbada.oracle.gui.types.cm.PageUpAction;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TypeAttrsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTypeName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBar;
    private ViewTable tableAttrs;
    private JToolBar toolBarColumns;

    public TypeAttrsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableAttrs.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableAttrs.addColumn((TableColumn)new QueryTableColumn("attr_no", this.stringManager.getString("pos"), 30));
            this.tableAttrs.addColumn((TableColumn)new QueryTableColumn("attr_name", this.stringManager.getString("attribute-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableAttrs.addColumn((TableColumn)new QueryTableColumn("attr_type_name", this.stringManager.getString("attribute-type"), 100));
            this.tableAttrs.addColumn((TableColumn)new QueryTableColumn("length", this.stringManager.getString("length"), 60));
            this.tableAttrs.addColumn((TableColumn)new QueryTableColumn("precision", this.stringManager.getString("precision"), 60));
            this.tableAttrs.addColumn((TableColumn)new QueryTableColumn("scale", this.stringManager.getString("scale"), 60));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("attr_name", this.stringManager.getString("attribute-name"), (String[])null));
            def.add(new SqlFilterDefComponent("attr_type_name", this.stringManager.getString("attribute-type"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-type-attrs-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableAttrs, (JButton)this.buttonActions, this.menuActions, "oracle-type-attrs-actions");
        SwingUtil.addAction((JComponent)this.tableAttrs, (javax.swing.Action)((Object)new PageUpAction(this)));
        SwingUtil.addAction((JComponent)this.tableAttrs, (javax.swing.Action)((Object)new PageDownAction(this)));
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TypeAttrsPanel-title");
    }

    public boolean requestFocusInWindow() {
        return this.tableAttrs.requestFocusInWindow();
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TypeAttrsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String attrName = null;
            this.requestRefresh = false;
            if (this.tableAttrs.getQuery().isActive() && this.tableAttrs.getSelectedRow() >= 0) {
                this.tableAttrs.getQuery().getRecord(this.tableAttrs.getSelectedRow());
                attrName = this.tableAttrs.getQuery().fieldByName("attr_name").getString();
            }
            this.tableAttrs.getQuery().close();
            this.tableAttrs.getQuery().setSqlText(Sql.getTypeAttrList(this.filter.getSqlText()));
            this.tableAttrs.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableAttrs.getQuery().paramByName("type_name").setString(this.currentTypeName);
            this.tableAttrs.getQuery().open();
            if (!this.tableAttrs.getQuery().isEmpty()) {
                if (attrName != null && this.tableAttrs.getQuery().locate("attr_name", new Variant(attrName))) {
                    this.tableAttrs.changeSelection(this.tableAttrs.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableAttrs.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTypeName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTypeName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableAttrs.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableAttrs = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeAttrsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeAttrsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TypeAttrsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableAttrs);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableAttrs);
        this.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }
}

