/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.types;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.types.cm.PageDownAction;
import pl.mpak.orbada.oracle.gui.types.cm.PageUpAction;
import pl.mpak.orbada.oracle.gui.wizards.CallObjectWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TypeMethodsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTypeName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmCallTypeMethod;
    private Action cmFilter;
    private Action cmRefresh;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBar;
    private ViewTable tableArguments;
    private ViewTable tableMethods;
    private JToolBar toolBarColumns;
    private ToolButton toolButton1;

    public TypeMethodsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableMethods.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TypeMethodsPanel.this.tableMethods.getSelectedRow();
                if (rowIndex >= 0 && TypeMethodsPanel.this.tableMethods.getQuery().isActive()) {
                    try {
                        TypeMethodsPanel.this.tableMethods.getQuery().getRecord(rowIndex);
                        TypeMethodsPanel.this.tableArguments.getQuery().close();
                        TypeMethodsPanel.this.tableArguments.getQuery().paramByName("method_name").setString(TypeMethodsPanel.this.tableMethods.getQuery().fieldByName("method_name").getString());
                        TypeMethodsPanel.this.tableArguments.getQuery().open();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableMethods.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("method_no", this.stringManager.getString("pos"), 30));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("method_range", this.stringManager.getString("method-range"), 80));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("method_type", this.stringManager.getString("method-type"), 100));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("method_name", this.stringManager.getString("method-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableMethods.addColumn((TableColumn)new QueryTableColumn("parameters", this.stringManager.getString("parameters"), 60));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("attr_name", this.stringManager.getString("attribute-name"), (String[])null));
            def.add(new SqlFilterDefComponent("attr_type_name", this.stringManager.getString("attribute-type"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-type-methods-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.tableArguments.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableArguments.getQuery().setSqlText(Sql.getPackageMethodArgumentList(null));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("overload", this.stringManager.getString("overload"), 30));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("position", this.stringManager.getString("pos"), 30));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("in_out", this.stringManager.getString("in-out"), 70));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("argument_name", this.stringManager.getString("argument-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("data_type", this.stringManager.getString("data-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableArguments.addColumn((TableColumn)new QueryTableColumn("default_value", this.stringManager.getString("default-value"), 200));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        SwingUtil.addAction((JComponent)this.tableMethods, (javax.swing.Action)this.cmCallTypeMethod);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableMethods, (JButton)this.buttonActions, this.menuActions, "oracle-type-methods-actions");
        SwingUtil.addAction((JComponent)this.tableMethods, (javax.swing.Action)((Object)new PageUpAction(this)));
        SwingUtil.addAction((JComponent)this.tableMethods, (javax.swing.Action)((Object)new PageDownAction(this)));
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TypeMethodsPanel-title");
    }

    public boolean requestFocusInWindow() {
        return this.tableMethods.requestFocusInWindow();
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TypeMethodsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String attrName = null;
            this.requestRefresh = false;
            if (this.tableMethods.getQuery().isActive() && this.tableMethods.getSelectedRow() >= 0) {
                this.tableMethods.getQuery().getRecord(this.tableMethods.getSelectedRow());
                attrName = this.tableMethods.getQuery().fieldByName("method_name").getString();
            }
            this.tableArguments.getQuery().close();
            this.tableMethods.getQuery().close();
            this.tableMethods.getQuery().setSqlText(Sql.getTypeMethodList(this.filter.getSqlText()));
            this.tableMethods.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableMethods.getQuery().paramByName("type_name").setString(this.currentTypeName);
            this.tableMethods.getQuery().open();
            this.tableArguments.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableArguments.getQuery().paramByName("package_name").setString(this.currentTypeName);
            if (!this.tableMethods.getQuery().isEmpty()) {
                if (attrName != null && this.tableMethods.getQuery().locate("method_name", new Variant(attrName))) {
                    this.tableMethods.changeSelection(this.tableMethods.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableMethods.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTypeName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTypeName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableMethods.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.cmCallTypeMethod = new Action();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tableMethods = new ViewTable();
        this.jScrollPane2 = new JScrollPane();
        this.tableArguments = new ViewTable();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeMethodsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeMethodsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.jMenuItem1.setAction((javax.swing.Action)this.cmCallTypeMethod);
        this.menuActions.add(this.jMenuItem1);
        this.cmCallTypeMethod.setActionCommandKey("cmCallTypeMethod");
        this.cmCallTypeMethod.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/call.gif"));
        this.cmCallTypeMethod.setText(this.stringManager.getString("cmCallTypeMethod-text"));
        this.cmCallTypeMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeMethodsPanel.this.cmCallTypeMethodActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TypeMethodsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableMethods);
        this.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolButton1.setAction((javax.swing.Action)this.cmCallTypeMethod);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton1);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jScrollPane1.setViewportView((Component)this.tableMethods);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setViewportView((Component)this.tableArguments);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmCallTypeMethodActionPerformed(ActionEvent evt) {
        if (this.tableMethods.getSelectedRow() >= 0) {
            try {
                this.tableMethods.getQuery().getRecord(this.tableMethods.getSelectedRow());
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CallObjectWizard(this.getDatabase(), this.currentSchemaName, this.currentTypeName + "." + this.tableMethods.getQuery().fieldByName("method_name").getString(), this.tableMethods.getQuery().fieldByName("overload").getString()), (boolean)true);
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }
}

