/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.types;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.types.TypeErrorsPanel;
import pl.mpak.orbada.oracle.gui.types.TypesPanelView;
import pl.mpak.orbada.oracle.gui.types.cm.PageDownAction;
import pl.mpak.orbada.oracle.gui.types.cm.PageUpAction;
import pl.mpak.orbada.oracle.services.OracleCompileErrorSettingsProvider;
import pl.mpak.orbada.oracle.syntax.parser.OraclePlSqlStructureParser;
import pl.mpak.orbada.oracle.util.OracleUtil;
import pl.mpak.orbada.oracle.util.SourceCreator;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.sky.gui.swing.syntax.structure.StructureParser;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TypeSourcePanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentObjectName = "";
    private String objectType;
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ImageIcon errIcon;
    private ISettings errorSettings;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private ToolButton buttonStore;
    private Action cmRefreshSource;
    private Action cmStore;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private OrbadaSyntaxTextArea syntaxSource;
    private JToolBar toolBarContent;

    public TypeSourcePanel(IViewAccesibilities accesibilities, String objectType) {
        this.accesibilities = accesibilities;
        this.objectType = objectType;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String objectName, final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TypeSourcePanel.this.syntaxSource.setDatabaseObject(TypeSourcePanel.this.currentSchemaName, TypeSourcePanel.this.objectType, objectName, text);
                TypeSourcePanel.this.syntaxSource.getEditorArea().setCaretPosition(0);
            }
        });
    }

    private void init() {
        this.syntaxSource.getStatusBar().addPanel("ddl-status").setText(" ");
        this.syntaxSource.setDatabase(this.getDatabase());
        this.syntaxSource.setStructureParser((StructureParser)new OraclePlSqlStructureParser());
        SwingUtil.addAction((JComponent)this.syntaxSource.getEditorArea(), (javax.swing.Action)this.cmStore);
        this.errIcon = ImageManager.getImage((String)"/pl/mpak/res/icons/stop10.gif");
        this.errorSettings = this.accesibilities.getApplication().getSettings(OracleCompileErrorSettingsProvider.settingsName);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.syntaxSource.getEditorArea(), (JButton)this.buttonActions, this.menuActions, "oracle-type-source-actions");
        SwingUtil.addAction((JComponent)this.syntaxSource.getEditorArea(), (javax.swing.Action)((Object)new PageUpAction(this)));
        SwingUtil.addAction((JComponent)this.syntaxSource.getEditorArea(), (javax.swing.Action)((Object)new PageDownAction(this)));
    }

    public String getObjectName() {
        return this.syntaxSource.getObjectName();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("TypeSourcePanel-title");
    }

    public void gotoPoint(int line, int column) {
        int offset = this.syntaxSource.getEditorArea().getLineStartOffset(line - 1) + column - 1;
        this.syntaxSource.getEditorArea().setCaretPosition(offset);
    }

    public boolean requestFocusInWindow() {
        return this.syntaxSource.getEditorArea().requestFocusInWindow();
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TypeSourcePanel.this.refresh();
            }
        });
    }

    public void refresh() {
        this.requestRefresh = false;
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)this.syntaxSource).getSource(this.currentSchemaName, this.objectType, this.currentObjectName);
        this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(" " + this.currentObjectName);
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
                this.setEditorText(null, "");
            }
        }
    }

    public boolean canClose() {
        return this.syntaxSource.canClose();
    }

    public void close() throws IOException {
        this.closing = true;
        this.syntaxSource.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefreshSource = new Action();
        this.menuActions = new JPopupMenu();
        this.cmStore = new Action();
        this.jPanel1 = new JPanel();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonStore = new ToolButton();
        this.buttonActions = new ToolButton();
        this.syntaxSource = new OrbadaSyntaxTextArea();
        this.cmRefreshSource.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshSource.setText(this.stringManager.getString("cmRefreshSource-text"));
        this.cmRefreshSource.setTooltip(this.stringManager.getString("cmRefreshSource-hint"));
        this.cmRefreshSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeSourcePanel.this.cmRefreshSourceActionPerformed(evt);
            }
        });
        this.cmStore.setActionCommandKey("cmStore");
        this.cmStore.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmStore.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/store_db.gif"));
        this.cmStore.setText(this.stringManager.getString("cmStore-text"));
        this.cmStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypeSourcePanel.this.cmStoreActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TypeSourcePanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefreshSource);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.toolBarContent.add(this.jSeparator1);
        this.buttonStore.setAction((javax.swing.Action)this.cmStore);
        this.buttonStore.setHorizontalTextPosition(0);
        this.buttonStore.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonStore);
        this.toolBarContent.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarContent);
        this.add((Component)this.jPanel1, "North");
        this.add((Component)this.syntaxSource, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshSourceActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmStoreActionPerformed(ActionEvent evt) {
        TypeErrorsPanel errors = (TypeErrorsPanel)SwingUtil.getTabbedPaneComponent(TypeErrorsPanel.class, (Component)this);
        this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("executing-3d"));
        try {
            this.syntaxSource.storeObject();
            if (errors != null) {
                errors.refresh();
                TypesPanelView view = (TypesPanelView)SwingUtil.getOwnerComponent(TypesPanelView.class, (Component)this);
                if (view != null) {
                    view.refresh();
                }
                this.syntaxSource.clearLineMarks();
                if (!errors.getQuery().eof()) {
                    this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("error-e") + " " + errors.getQuery().fieldByName("text").getString());
                    this.syntaxSource.setLineMark(OracleUtil.getErrLines(errors.getQuery(), this.errorSettings.getValue(OracleCompileErrorSettingsProvider.setErrorLineColor, SwingUtil.Color.DARKORANGE), this.errIcon));
                    if (this.errorSettings.getValue(OracleCompileErrorSettingsProvider.setOnErrorGoToTab, Boolean.valueOf(true)).booleanValue()) {
                        JTabbedPane tp = (JTabbedPane)SwingUtil.getOwnerComponent(JTabbedPane.class, (Component)this);
                        if (tp != null) {
                            tp.setSelectedComponent(errors);
                        }
                    } else {
                        errors.getQuery().first();
                        this.gotoPoint(errors.getQuery().fieldByName("line").getInteger(), errors.getQuery().fieldByName("position").getInteger());
                    }
                } else {
                    this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("stored"));
                }
            }
        }
        catch (Exception ex) {
            this.syntaxSource.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("error-e"));
            if (ex instanceof NullPointerException) {
                ExceptionUtil.processException((Throwable)ex);
            }
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }
}

