/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.types;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.freezing.TypeFreezeViewService;
import pl.mpak.orbada.oracle.gui.types.TypeTabbedPane;
import pl.mpak.orbada.oracle.gui.wizards.CompileAllObjectsWizard;
import pl.mpak.orbada.oracle.gui.wizards.type.CreateObjectTypeWizard;
import pl.mpak.orbada.oracle.gui.wizards.type.CreateTableTypeWizard;
import pl.mpak.orbada.oracle.gui.wizards.type.CreateVarrayTypeWizard;
import pl.mpak.orbada.oracle.gui.wizards.type.DropTypeWizard;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TypesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ISettings settings;
    private Timer timer;
    private OrbadaTabbedPane tabbedPane;
    private boolean refreshing = false;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonFilter;
    private ToolButton buttonFreezeObject;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmCompile;
    private Action cmCompileAll;
    private Action cmCompileAllInvalid;
    private Action cmCreateObjectType;
    private Action cmCreateTableType;
    private Action cmCreateVarrayType;
    private Action cmDropType;
    private Action cmFilter;
    private Action cmFreezeObject;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JPopupMenu menuActions;
    private JMenuItem menuCompileAll;
    private JMenuItem menuCompileAllInvalid;
    private JMenuItem menuCreateObjectType;
    private JMenuItem menuCreateTableType;
    private JMenuItem menuCreateVarrayType;
    private JMenuItem menuDropType;
    private JPanel panelTables;
    private JSplitPane split;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableTypes;
    private JToolBar toolBarTables;

    public TypesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TypesPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timer);
        this.tabbedPane = new TypeTabbedPane(this.accesibilities);
        this.split.setRightComponent((Component)this.tabbedPane);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-types-panel");
        this.split.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.split.getDividerLocation())).intValue());
        this.currentSchemaName = OracleDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.tableTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (!TypesPanelView.this.refreshing) {
                    if (this.lastIndex != TypesPanelView.this.tableTypes.getSelectedRow() && !TypesPanelView.this.tabbedPane.canClose()) {
                        TypesPanelView.this.tableTypes.changeSelection(this.lastIndex, TypesPanelView.this.tableTypes.getSelectedColumn());
                        return;
                    }
                    this.lastIndex = TypesPanelView.this.tableTypes.getSelectedRow();
                    TypesPanelView.this.timer.restart();
                }
            }
        });
        this.tableTypes.getQuery().setDatabase(this.getDatabase());
        this.tableTypes.addColumn((TableColumn)new QueryTableColumn("type_name", this.stringManager.getString("type-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTypes.addColumn((TableColumn)new QueryTableColumn("TYPECODE", this.stringManager.getString("type-code"), 70));
        QueryTableCellRendererFilter rf = new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("VALID")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("INVALID")) {
                    ((JLabel)renderer).setForeground(Color.RED);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("DEBUG")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.NAVY);
                }
            }
        };
        this.tableTypes.addColumn((TableColumn)new QueryTableColumn("HEAD_STATUS", this.stringManager.getString("head-status"), 60, (TableCellRenderer)new QueryTableCellRenderer(rf)));
        this.tableTypes.addColumn((TableColumn)new QueryTableColumn("BODY_STATUS", this.stringManager.getString("body-status"), 60, (TableCellRenderer)new QueryTableCellRenderer(rf)));
        this.tableTypes.addColumn((TableColumn)new QueryTableColumn("HEAD_CREATED", this.stringManager.getString("head-created"), 110));
        this.tableTypes.addColumn((TableColumn)new QueryTableColumn("BODY_CREATED", this.stringManager.getString("body-created"), 110));
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("type_name", this.stringManager.getString("type-name"), (String[])null));
        def.add(new SqlFilterDefComponent("TYPECODE", this.stringManager.getString("type-code"), (String[])null));
        def.add(new SqlFilterDefComponent("(HEAD_STATUS = 'INVALID' or BODY_STATUS = 'INVALID')", this.stringManager.getString("invalid")));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-types-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        SwingUtil.addAction((JComponent)this.tableTypes, (javax.swing.Action)this.cmCompile);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTypes, (JButton)this.buttonActions, this.menuActions, "oracle-types-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TypesPanelView.this.tableTypes.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(OracleDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void refreshTabbedPanes() {
        String typeName = "";
        int rowIndex = this.tableTypes.getSelectedRow();
        if (rowIndex >= 0 && this.tableTypes.getQuery().isActive()) {
            try {
                this.tableTypes.getQuery().getRecord(rowIndex);
                typeName = this.tableTypes.getQuery().fieldByName("type_name").getString();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tabbedPane.refresh(null, this.currentSchemaName, typeName);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TypesPanelView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String typeName = null;
            if (this.tableTypes.getQuery().isActive() && this.tableTypes.getSelectedRow() >= 0) {
                this.tableTypes.getQuery().getRecord(this.tableTypes.getSelectedRow());
                typeName = this.tableTypes.getQuery().fieldByName("TYPE_NAME").getString();
            }
            this.refresh(typeName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        this.refreshing = true;
        try {
            int column = this.tableTypes.getSelectedColumn();
            int index = Math.max(0, this.tableTypes.getSelectedRow());
            this.tableTypes.getQuery().close();
            this.tableTypes.getQuery().setSqlText(Sql.getTypeList(this.filter.getSqlText(), OracleDbInfoProvider.instance.getMajorVersion(this.getDatabase())));
            this.tableTypes.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableTypes.getQuery().open();
            if (objectName != null && this.tableTypes.getQuery().locate("TYPE_NAME", new Variant(objectName))) {
                this.tableTypes.changeSelection(this.tableTypes.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableTypes.getQuery().isEmpty()) {
                this.tableTypes.changeSelection(Math.min(index, this.tableTypes.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        return this.tabbedPane.canClose();
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.settings.setValue("split-location", Long.valueOf(this.split.getDividerLocation()));
        this.viewClosing = true;
        this.tabbedPane.close();
        this.tableTypes.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCreateObjectType = new JMenuItem();
        this.menuCreateTableType = new JMenuItem();
        this.menuCreateVarrayType = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuCompileAll = new JMenuItem();
        this.menuCompileAllInvalid = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuDropType = new JMenuItem();
        this.cmCompile = new Action();
        this.cmFreezeObject = new Action();
        this.cmDropType = new Action();
        this.cmCreateObjectType = new Action();
        this.cmCreateTableType = new Action();
        this.cmCreateVarrayType = new Action();
        this.cmCompileAll = new Action();
        this.cmCompileAllInvalid = new Action();
        this.split = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTypes = new ViewTable();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.buttonFreezeObject = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonCompile = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jPanel2 = new JPanel();
        this.statusBarTables = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuCreateObjectType.setAction((javax.swing.Action)this.cmCreateObjectType);
        this.menuActions.add(this.menuCreateObjectType);
        this.menuCreateTableType.setAction((javax.swing.Action)this.cmCreateTableType);
        this.menuActions.add(this.menuCreateTableType);
        this.menuCreateVarrayType.setAction((javax.swing.Action)this.cmCreateVarrayType);
        this.menuActions.add(this.menuCreateVarrayType);
        this.menuActions.add(this.jSeparator3);
        this.menuCompileAll.setAction((javax.swing.Action)this.cmCompileAll);
        this.menuActions.add(this.menuCompileAll);
        this.menuCompileAllInvalid.setAction((javax.swing.Action)this.cmCompileAllInvalid);
        this.menuActions.add(this.menuCompileAllInvalid);
        this.menuActions.add(this.jSeparator2);
        this.menuDropType.setAction((javax.swing.Action)this.cmDropType);
        this.menuActions.add(this.menuDropType);
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmCompile.setText(this.stringManager.getString("cmCompile-text"));
        this.cmCompile.setTooltip(this.stringManager.getString("cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmCompileActionPerformed(evt);
            }
        });
        this.cmFreezeObject.setActionCommandKey("cmFreezeObject");
        this.cmFreezeObject.setShortCut(KeyStroke.getKeyStroke(114, 0));
        this.cmFreezeObject.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.cmFreezeObject.setText(this.stringManager.getString("cmFreezeObject-text"));
        this.cmFreezeObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmFreezeObjectActionPerformed(evt);
            }
        });
        this.cmDropType.setActionCommandKey("cmDropType");
        this.cmDropType.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropType.setText(this.stringManager.getString("cmDropType-text"));
        this.cmDropType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmDropTypeActionPerformed(evt);
            }
        });
        this.cmCreateObjectType.setActionCommandKey("cmCreateObjectType");
        this.cmCreateObjectType.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/type.gif"));
        this.cmCreateObjectType.setText(this.stringManager.getString("cmCreateObjectType-text"));
        this.cmCreateObjectType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmCreateObjectTypeActionPerformed(evt);
            }
        });
        this.cmCreateTableType.setActionCommandKey("cmCreateTableType");
        this.cmCreateTableType.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/type.gif"));
        this.cmCreateTableType.setText(this.stringManager.getString("cmCreateTableType-text"));
        this.cmCreateTableType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmCreateTableTypeActionPerformed(evt);
            }
        });
        this.cmCreateVarrayType.setActionCommandKey("cmCreateVarrayType");
        this.cmCreateVarrayType.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/type.gif"));
        this.cmCreateVarrayType.setText(this.stringManager.getString("cmCreateVarrayType-text"));
        this.cmCreateVarrayType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmCreateVarrayTypeActionPerformed(evt);
            }
        });
        this.cmCompileAll.setActionCommandKey("cmCompileAll");
        this.cmCompileAll.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute_all.gif"));
        this.cmCompileAll.setText(this.stringManager.getString("cmCompileAll-text"));
        this.cmCompileAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmCompileAllActionPerformed(evt);
            }
        });
        this.cmCompileAllInvalid.setActionCommandKey("cmCompileAllInvalid");
        this.cmCompileAllInvalid.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute_all_invalid.gif"));
        this.cmCompileAllInvalid.setText(this.stringManager.getString("cmCompileAllInvalid-text"));
        this.cmCompileAllInvalid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TypesPanelView.this.cmCompileAllInvalidActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TypesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTypes);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.buttonFreezeObject.setAction((javax.swing.Action)this.cmFreezeObject);
        this.buttonFreezeObject.setHorizontalTextPosition(0);
        this.buttonFreezeObject.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFreezeObject);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonCompile);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTypes);
        this.jPanel2.add((Component)this.statusBarTables, "South");
        this.panelTables.add((Component)this.jPanel2, "South");
        this.split.setLeftComponent(this.panelTables);
        this.add((Component)this.split, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTypes.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    TypesPanelView.this.setCurrentSchemaName(o.toString());
                    TypesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmCompileActionPerformed(ActionEvent evt) {
        if (this.tableTypes.getSelectedRow() >= 0) {
            try {
                this.tableTypes.getQuery().getRecord(this.tableTypes.getSelectedRow());
                String typeName = this.tableTypes.getQuery().fieldByName("type_name").getString();
                this.getDatabase().executeCommand("ALTER TYPE " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)typeName) + " COMPILE" + (OracleDbInfoProvider.instance.isDebugClauseNeeded(this.getDatabase()) ? " DEBUG" : ""));
                this.refresh();
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFreezeObjectActionPerformed(ActionEvent evt) {
        if (this.tableTypes.getSelectedRow() >= 0) {
            try {
                this.tableTypes.getQuery().getRecord(this.tableTypes.getSelectedRow());
                String typeName = this.tableTypes.getQuery().fieldByName("type_name").getString();
                this.accesibilities.createView((ViewProvider)new TypeFreezeViewService(this.accesibilities, this.currentSchemaName, typeName));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmDropTypeActionPerformed(ActionEvent evt) {
        if (this.tableTypes.getSelectedRow() >= 0) {
            try {
                this.tableTypes.getQuery().getRecord(this.tableTypes.getSelectedRow());
                String typeName = this.tableTypes.getQuery().fieldByName("type_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new DropTypeWizard(this.getDatabase(), this.currentSchemaName, typeName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmCreateObjectTypeActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateObjectTypeWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCreateTableTypeActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateTableTypeWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCreateVarrayTypeActionPerformed(ActionEvent evt) {
        if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateVarrayTypeWizard(this.getDatabase(), this.currentSchemaName), (boolean)true) != null) {
            this.refresh();
        }
    }

    private void cmCompileAllActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompileAllObjectsWizard(this.getDatabase(), this.currentSchemaName, "TYPE", null), (boolean)true);
    }

    private void cmCompileAllInvalidActionPerformed(ActionEvent evt) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CompileAllObjectsWizard(this.getDatabase(), this.currentSchemaName, "TYPE", "INVALID"), (boolean)true);
    }
}

