/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.universal;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.universal.ExplainPlanPanel;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExplainPlanDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String sqlText;
    private ExplainPlanPanel planPanel;
    private ISettings settings;
    private JButton buttonClose;
    private Action cmClose;
    private JPanel panelExplaintPlan;

    public static void show(Database database, String sqlText) {
        ExplainPlanDialog dialog = new ExplainPlanDialog(database, sqlText);
        dialog.setVisible(true);
    }

    public ExplainPlanDialog(Database database, String sqlText) {
        super(SwingUtil.getRootFrame(), true);
        this.database = database;
        this.sqlText = sqlText;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.planPanel = new ExplainPlanPanel(this.database, this.sqlText);
        this.panelExplaintPlan.add(this.planPanel);
        this.getRootPane().setDefaultButton(this.buttonClose);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.settings = Application.get().getSettings("oracle-explain-plan-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", Long.valueOf(this.getWidth())).intValue(), this.settings.getValue("height", Long.valueOf(this.getHeight())).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonClose});
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        try {
            this.planPanel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.settings.setValue("width", Long.valueOf(this.getWidth()));
        this.settings.setValue("height", Long.valueOf(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.buttonClose = new JButton();
        this.panelExplaintPlan = new JPanel();
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(this.stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExplainPlanDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExplainPlanDialog-title"));
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(85, 25));
        this.panelExplaintPlan.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonClose, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.panelExplaintPlan, -1, 556, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelExplaintPlan, -1, 363, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

