/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.universal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.patt.Resolvers;

public class ExplainPlanPanel
extends JPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private TextArea textPlan;
    private JTree treePlan;

    public ExplainPlanPanel(Database database, String sqlText) {
        this.database = database;
        this.initComponents();
        this.init();
        this.updatePlan(sqlText);
    }

    private void init() {
        this.treePlan.getSelectionModel().setSelectionMode(1);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void fillTree(Query query, DefaultMutableTreeNode node) {
        try {
            if (query.eof()) {
                return;
            }
            long firstLevel = query.fieldByName("level").getLong();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(query.fieldByName("plan_output").getString());
            node.add(newNode);
            query.next();
            while (!query.eof()) {
                if (query.fieldByName("level").getLong() > firstLevel) {
                    this.fillTree(query, newNode);
                    continue;
                }
                if (query.fieldByName("level").getLong() >= firstLevel) {
                    newNode = new DefaultMutableTreeNode(query.fieldByName("plan_output").getString());
                    node.add(newNode);
                    query.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlan(String sqlText) {
        String id = Resolvers.expand((String)"$(user.name)/$(orbada.current.date)/$(orbada.current.time)");
        if (id.length() > 30) {
            id = id.substring(0, 29);
        }
        Command command = this.database.createCommand();
        try {
            command.setParamCheck(false);
            command.execute("explain plan set statement_id = '" + id + "' into plan_table for\n" + sqlText);
            Query query = this.database.createQuery();
            try {
                query.setSqlText(Sql.getExplainPlan());
                query.paramByName("statement_id").setString(id);
                query.open();
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
                this.fillTree(query, root);
                this.treePlan.setModel(new DefaultTreeModel(root));
                if (root.getChildCount() > 0) {
                    this.treePlan.setSelectionInterval(0, 0);
                }
                this.expandAll(this.treePlan, new TreePath(root), true);
                this.textPlan.setText("");
                try {
                    query.setSqlText(Sql.getExplainXPlan());
                    query.paramByName("statement_id").setString(id);
                    query.open();
                    while (!query.eof()) {
                        this.textPlan.append(query.fieldByName("plan_table_output").getString() + "\n");
                        query.next();
                    }
                }
                catch (Exception ex) {
                    this.textPlan.append(this.stringManager.getString("ExplainPlanPanel-dbms-xplan-error-info") + "\n" + ex.getMessage());
                }
            }
            finally {
                query.close();
            }
            this.database.executeCommand("delete from plan_table where statement_id = '" + id + "'");
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void close() throws IOException {
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.treePlan = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.textPlan = new TextArea();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setFocusable(false);
        this.treePlan.setModel(null);
        this.treePlan.setRootVisible(false);
        this.treePlan.setRowHeight(18);
        this.treePlan.setShowsRootHandles(true);
        this.jScrollPane1.setViewportView(this.treePlan);
        this.jTabbedPane1.addTab(this.stringManager.getString("ExplainPlanPanel-tree"), this.jScrollPane1);
        this.textPlan.setColumns(20);
        this.textPlan.setEditable(false);
        this.textPlan.setRows(5);
        this.textPlan.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane2.setViewportView((Component)this.textPlan);
        this.jTabbedPane1.addTab(this.stringManager.getString("ExplainPlanPanel-details"), this.jScrollPane2);
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

