/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;

public class MViewIndexComboBoxModel
extends DefaultComboBoxModel {
    private Database database;
    private String schemaName;
    private String viewName;
    private DbDatabaseInfo info;

    public MViewIndexComboBoxModel(Database database) {
        this.database = database;
        this.info = OracleDbInfoProvider.instance.getDatabaseInfo(database);
        this.init();
    }

    public MViewIndexComboBoxModel(Database database, String schemaName, String viewName) {
        this(database);
        this.change(schemaName, viewName);
    }

    public void change(String schemaName, String tableName) {
        this.viewName = tableName;
        this.schemaName = schemaName == null ? this.database.getUserName().toUpperCase() : schemaName;
        this.removeAllElements();
        DbObjectIdentified list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/MATERIALIZED VIEWS/" + tableName + "/INDEXES");
        list.saveRefresh();
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                if (this.getIndexOf(i) != -1) continue;
                this.addElement(i);
            }
        }
    }

    public void select(String indexName, JComboBox combo) {
        if (indexName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(indexName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

