/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;

public class SynonymComboBoxModel
extends DefaultComboBoxModel {
    private Database database;
    private String schemaName;
    private DbDatabaseInfo info;

    public SynonymComboBoxModel(Database database) {
        this.database = database;
        this.info = OracleDbInfoProvider.instance.getDatabaseInfo(database);
        this.init();
    }

    public SynonymComboBoxModel(Database database, String schemaName) {
        this(database);
        this.change(schemaName);
    }

    public void change(String schemaName) {
        this.schemaName = schemaName == null ? this.database.getUserName().toUpperCase() : schemaName;
        this.removeAllElements();
        DbObjectIdentified list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/SYNONYMS");
        list.saveRefresh();
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                this.addElement(i);
            }
        }
    }

    public void select(String synonymName, JComboBox combo) {
        if (synonymName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(synonymName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

