/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;

public class TableConstraintComboBoxModel
extends DefaultComboBoxModel {
    private Database database;
    private String schemaName;
    private String tableName;
    private DbDatabaseInfo info;

    public TableConstraintComboBoxModel(Database database) {
        this.database = database;
        this.info = OracleDbInfoProvider.instance.getDatabaseInfo(database);
        this.init();
    }

    public TableConstraintComboBoxModel(Database database, String schemaName, String tableName) {
        this(database);
        this.change(schemaName, tableName);
    }

    public void change(String schemaName, String tableName) {
        this.tableName = tableName;
        this.schemaName = schemaName == null ? this.database.getUserName().toUpperCase() : schemaName;
        this.removeAllElements();
        DbObjectIdentified list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/TABLES/" + tableName + "/CONSTRAINTS");
        list.saveRefresh();
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                if (this.getIndexOf(i) != -1) continue;
                this.addElement(i);
            }
        }
    }

    public void select(String constraintName, JComboBox combo) {
        if (constraintName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(constraintName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

