/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;

public class TriggerComboBoxModel
extends DefaultComboBoxModel {
    private Database database;
    private String schemaName;
    private String objectName;
    private DbDatabaseInfo info;

    public TriggerComboBoxModel(Database database) {
        this.database = database;
        this.info = OracleDbInfoProvider.instance.getDatabaseInfo(database);
        this.init();
    }

    public void change(String schemaName, String objectName, String tableType) {
        this.objectName = objectName;
        this.schemaName = schemaName == null ? this.database.getUserName().toUpperCase() : schemaName;
        this.removeAllElements();
        DbObjectIdentified list = null;
        if (this.objectName != null) {
            if ("TABLE".equalsIgnoreCase(tableType)) {
                list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/TABLES/" + objectName + "/TRIGGERS");
            } else if ("VIEW".equalsIgnoreCase(tableType)) {
                list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/VIEWS/" + objectName + "/TRIGGERS");
            } else if ("MATERIALIZED VIEW".equalsIgnoreCase(tableType)) {
                list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/MATERIALIZED VIEWS/" + objectName + "/TRIGGERS");
            }
        } else {
            list = this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/TRIGGERS");
        }
        list.saveRefresh();
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                this.addElement(i);
            }
        }
    }

    public void select(String triggerName, JComboBox combo) {
        if (triggerName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(triggerName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

