/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.gui.wizards.view.CommentViewColumnWizard;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class ViewColumnsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentViewName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private SqlFilter filter;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmColumnListCopy;
    private Action cmComment;
    private Action cmFilter;
    private Action cmRefresh;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu menuActions;
    private JMenuItem menuCommentColumn;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableColumns;
    private JToolBar toolBarColumns;
    private ToolButton toolButton1;
    private ToolButton toolButton2;

    public ViewColumnsPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = ViewColumnsPanel.this.tableColumns.getSelectedRow();
                if (rowIndex >= 0 && ViewColumnsPanel.this.tableColumns.getQuery().isActive()) {
                    try {
                        ViewColumnsPanel.this.tableColumns.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableColumns.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_id", this.stringManager.getString("pos"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("display_type", this.stringManager.getString("display-column-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("nullable", this.stringManager.getString("is-null"), 40));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("updatable", this.stringManager.getString("is-updatable"), 40, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                    if (StringUtil.nvl((String)((String)value), (String)"").equals("YES")) {
                        ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                    } else if (StringUtil.nvl((String)((String)value), (String)"").equals("NO")) {
                        ((JLabel)renderer).setForeground(Color.RED);
                    }
                }
            })));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("remarks", this.stringManager.getString("comment"), 300));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("cols.column_name", this.stringManager.getString("column-name"), (String[])null));
            def.add(new SqlFilterDefComponent("cols.data_type", this.stringManager.getString("column-type"), new String[]{"", "'VARCHAR%'", "'NUMERIC%'", "'INTEGER%'", "'TIMESTAMP%'", "'DATE'"}));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "oracle-view-columns-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableColumns, (JButton)this.buttonActions, this.menuActions, "oracle-view-columns-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("ViewColumnsPanel-title");
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ViewColumnsPanel.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            String columnName = null;
            this.requestRefresh = false;
            int column = this.tableColumns.getSelectedColumn();
            if (this.tableColumns.getQuery().isActive() && this.tableColumns.getSelectedRow() >= 0) {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                columnName = this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString();
            }
            this.tableColumns.getQuery().close();
            this.tableColumns.getQuery().setSqlText(Sql.getViewColumnList(this.filter.getSqlText()));
            this.tableColumns.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableColumns.getQuery().paramByName("view_name").setString(this.currentViewName);
            this.tableColumns.getQuery().open();
            if (!this.tableColumns.getQuery().isEmpty()) {
                if (columnName != null && this.tableColumns.getQuery().locate("column_name", new Variant(columnName))) {
                    this.tableColumns.changeSelection(this.tableColumns.getQuery().getCurrentRecord().getIndex(), column);
                } else {
                    this.tableColumns.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentViewName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentViewName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableColumns.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.menuCommentColumn = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.cmComment = new Action();
        this.cmColumnListCopy = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.toolButton1 = new ToolButton();
        this.toolButton2 = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewColumnsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewColumnsPanel.this.cmFilterActionPerformed(evt);
            }
        });
        this.menuCommentColumn.setAction((javax.swing.Action)this.cmComment);
        this.menuActions.add(this.menuCommentColumn);
        this.jMenuItem1.setAction((javax.swing.Action)this.cmColumnListCopy);
        this.menuActions.add(this.jMenuItem1);
        this.cmComment.setActionCommandKey("cmComment");
        this.cmComment.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/comment_edit.gif"));
        this.cmComment.setText(this.stringManager.getString("cmComment-text"));
        this.cmComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewColumnsPanel.this.cmCommentActionPerformed(evt);
            }
        });
        this.cmColumnListCopy.setActionCommandKey("cmColumnListCopy");
        this.cmColumnListCopy.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/copy.gif"));
        this.cmColumnListCopy.setText(this.stringManager.getString("cmColumnListCopy-text"));
        this.cmColumnListCopy.setTooltip(this.stringManager.getString("cmColumnListCopy-hint"));
        this.cmColumnListCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewColumnsPanel.this.cmColumnListCopyActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ViewColumnsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableColumns);
        this.add((Component)this.statusBarColumns, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.toolBarColumns.add(this.jSeparator1);
        this.toolButton1.setAction((javax.swing.Action)this.cmComment);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton1);
        this.toolButton2.setAction((javax.swing.Action)this.cmColumnListCopy);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.toolButton2);
        this.toolBarColumns.add(this.jSeparator2);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmCommentActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectionModel().getLeadSelectionIndex());
                String columnName = this.tableColumns.getQuery().fieldByName("column_name").getString();
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CommentViewColumnWizard(this.getDatabase(), this.currentSchemaName, this.currentViewName, columnName), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmColumnListCopyActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getQuery().isActive()) {
            try {
                StringBuffer sb = new StringBuffer();
                int l = 0;
                this.tableColumns.getQuery().first();
                while (!this.tableColumns.getQuery().eof()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                        l += 2;
                    }
                    if (l > 100) {
                        l = 0;
                        sb.append('\n');
                    }
                    String column = SQLUtil.createSqlName((String)this.tableColumns.getQuery().fieldByName("COLUMN_NAME").getString());
                    sb.append(column);
                    l += column.length();
                    this.tableColumns.getQuery().next();
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(sb.toString()), null);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }
}

