/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleSequenceInfo;
import pl.mpak.orbada.oracle.gui.util.SequenceComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.SequenceItemListener;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class AlterSequenceWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String sequenceName;
    private JCheckBox checkCycle;
    private JCheckBox checkOrder;
    private JComboBox comboSequences;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private TextField textCacheSize;
    private TextField textInc;
    private TextField textMax;
    private TextField textMin;
    private TextField textStart;

    public AlterSequenceWizard(Database database, String schemaName, String sequenceName) {
        this.database = database;
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.schemaName = this.schemaName == null ? OracleDbInfoProvider.getCurrentSchema(this.database) : this.schemaName;
        this.comboSequences.setModel(new SequenceComboBoxModel(this.database));
        this.comboSequences.addItemListener(new SequenceItemListener(){

            public void itemChanged(OracleSequenceInfo info) {
                AlterSequenceWizard.this.textStart.setText(info.getLastValue().toString());
                AlterSequenceWizard.this.textMin.setText(info.getMinimumValue().toString());
                AlterSequenceWizard.this.textMax.setText("999999999999999999999999999".equals(info.getMaximumValue().toString()) ? "" : info.getMaximumValue().toString());
                AlterSequenceWizard.this.textInc.setText(info.getIncrement().toString());
                AlterSequenceWizard.this.textCacheSize.setText("0".equals(info.getBufferSize().toString()) ? "" : info.getBufferSize().toString());
                AlterSequenceWizard.this.checkCycle.setSelected("YES".equals(info.getCycle()));
                AlterSequenceWizard.this.checkOrder.setSelected("YES".equals(info.getOrdered()));
            }
        });
    }

    public void wizardShow() {
        ((SequenceComboBoxModel)this.comboSequences.getModel()).change(this.schemaName);
        ((SequenceComboBoxModel)this.comboSequences.getModel()).select(this.sequenceName, this.comboSequences);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("AlterSequenceWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("AlterSequenceWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER SEQUENCE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboSequences.getSelectedItem().toString()) + "\n" + "  INCREMENT BY " + this.textInc.getText() + "\n" + "  " + (StringUtil.isEmpty((String)this.textMin.getText()) ? "NOMINVALUE" : "MINVALUE " + this.textMin.getText()) + "\n" + "  " + (StringUtil.isEmpty((String)this.textMax.getText()) ? "NOMAXVALUE" : "MAXVALUE " + this.textMax.getText()) + "\n" + "  " + (StringUtil.isEmpty((String)this.textCacheSize.getText()) ? "NOCACHE" : "CACHE " + this.textCacheSize.getText()) + "\n" + "  " + (this.checkCycle.isSelected() ? "CYCLE" : "NOCYCLE") + "\n" + "  " + (this.checkOrder.isSelected() ? "ORDER" : "NOORDER");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel8 = new JLabel();
        this.comboSequences = new JComboBox();
        this.jLabel2 = new JLabel();
        this.textStart = new TextField();
        this.jLabel3 = new JLabel();
        this.textMin = new TextField();
        this.textMax = new TextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.textCacheSize = new TextField();
        this.checkCycle = new JCheckBox();
        this.checkOrder = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.textInc = new TextField();
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("sequence-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("start-at-dd"));
        this.textStart.setEditable(false);
        this.textStart.setText("1");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("minimum-value-dd"));
        this.textMin.setText("1");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("maximum-value-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("buffer-size-dd"));
        this.checkCycle.setText(this.stringManager.getString("cycle"));
        this.checkOrder.setText(this.stringManager.getString("keep-order"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("change-by-dd"));
        this.textInc.setText("1");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSequences, 0, 233, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel6, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textInc, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel4, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textMax, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textMin, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textStart, -2, 179, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.checkCycle).addComponent(this.checkOrder, -1, -1, Short.MAX_VALUE).addComponent((Component)this.textCacheSize, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.comboSequences, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textMin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textInc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textCacheSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCycle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkOrder).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

