/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.oracle.util.SourceCreator;
import pl.mpak.orbada.universal.gui.CommandParametersPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.ParameterList;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CallObjectWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String objectName;
    private String overload;
    private SourceCreator sourceCreator;
    private String sqlCode;
    private Command command;
    private CommandParametersPanel parameters;

    public CallObjectWizard(Database database, String schemaName, String objectName, String overload) {
        this.database = database;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.overload = overload;
        this.sourceCreator = new SourceCreator(database);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.schemaName = this.schemaName == null ? OracleDbInfoProvider.getCurrentSchema(this.database) : this.schemaName;
        this.setSize(560, 400);
    }

    public void wizardShow() {
        this.sqlCode = this.sourceCreator.getSource(this.schemaName, "CALL", this.objectName, this.overload);
        this.command = this.database.createCommand();
        try {
            this.command.setSqlText(this.sqlCode);
        }
        catch (UseDBException ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        if (this.command.getParameterCount() > 0) {
            this.parameters = new CommandParametersPanel((ParametrizedCommand)this.command);
            this.add((Component)this.parameters);
            this.parameters.setFocus();
        }
    }

    public void close() throws IOException {
        if (this.parameters != null) {
            this.parameters.close();
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CallObjectWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CallObjectWizard-tab-title");
    }

    public String getSqlCode() {
        return this.sqlCode;
    }

    public boolean execute() {
        try {
            if (this.parameters != null) {
                this.parameters.updateParameters();
            }
            this.command.execute();
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    public ParameterList getParameterList() {
        return this.command.getParameterList();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

