/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.SchemaComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CompileAllObjectsWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String objectType;
    private String objectStatus;
    private JComboBox comboSchemas;
    private JComboBox comboStatus;
    private JComboBox comboType;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;

    public CompileAllObjectsWizard(Database database, String schemaName, String objectType, String objectStatus) {
        this.database = database;
        this.schemaName = schemaName;
        this.objectType = objectType;
        this.objectStatus = objectStatus;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboSchemas.setModel(new SchemaComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).change();
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).select(this.schemaName, this.comboSchemas);
        if (this.objectStatus != null) {
            this.comboStatus.setSelectedItem(this.objectStatus);
        }
        if (this.objectType != null) {
            this.comboType.setSelectedItem(this.objectType);
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CompileAllObjectsWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CompileAllObjectsWizard-tab-title");
    }

    public String getSqlCode() {
        String schema = this.comboSchemas.getSelectedItem().toString();
        String type = this.comboType.getSelectedItem().toString();
        String status = this.comboStatus.getSelectedItem().toString();
        String typeCond = null;
        if (!"ALL".equals(type)) {
            typeCond = "PACKAGE".equals(type) ? "(OBJECT_TYPE = 'PACKAGE' or OBJECT_TYPE = 'PACKAGE BODY')" : "OBJECT_TYPE = '" + type + "'";
        }
        return "BEGIN\n  FOR CUR IN (SELECT OBJECT_NAME, OBJECT_TYPE, OWNER FROM ALL_OBJECTS \n               WHERE OWNER = '" + schema + "'\n" + (typeCond == null ? "" : "                 AND " + typeCond + "\n") + ("ALL".equals(status) ? "" : "                 AND STATUS = '" + status + "'\n") + "  ) LOOP\n" + "    BEGIN\n" + "      IF CUR.OBJECT_TYPE = 'PACKAGE BODY' THEN\n" + "        EXECUTE IMMEDIATE 'ALTER PACKAGE \"'||CUR.OWNER||'\".\"'||CUR.OBJECT_NAME||'\" COMPILE BODY';\n" + "      ELSE\n" + "        EXECUTE IMMEDIATE 'ALTER '||CUR.OBJECT_TYPE||' \"'||CUR.OWNER||'\".\"'||CUR.OBJECT_NAME||'\" COMPILE'; \n" + "      END IF;\n" + "    EXCEPTION\n" + "      WHEN OTHERS THEN\n" + "        NULL;\n" + "    END;\n" + "  END LOOP;\n" + "END;";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.comboType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.comboSchemas = new JComboBox();
        this.comboStatus = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("type-objects-dd"));
        this.comboType.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "FUNCTION", "PROCEDURE", "PACKAGE", "TYPE", "JAVA SOURCE", "TRIGGER", "VIEW"}));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("schema-dd"));
        this.comboStatus.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "INVALID", "VALID"}));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("object-state-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboType, 0, 246, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSchemas, 0, 246, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboStatus, 0, 246, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboSchemas, -2, -1, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.comboStatus, -2, -1, -2)).addContainerGap(112, Short.MAX_VALUE)));
    }
}

