/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateDbLinkWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private JCheckBox checkCurrentUser;
    private JCheckBox checkPublic;
    private JCheckBox checkShared;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel labelConnectPassword;
    private JLabel labelConnectUser;
    private JLabel labelSharedPassword;
    private JLabel labelSharedUser;
    private TextField textConnectPassword;
    private TextField textConnectUser;
    private TextField textHost;
    private TextField textName;
    private TextField textSharedPassword;
    private TextField textSharedUser;

    public CreateDbLinkWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.schemaName = this.schemaName == null ? OracleDbInfoProvider.getCurrentSchema(this.database) : this.schemaName;
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateDbLinkWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateDbLinkWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        return "CREATE" + (this.checkShared.isSelected() ? " SHARED" : "") + (this.checkPublic.isSelected() ? " PUBLIC" : "") + " DATABASE LINK " + this.textName.getText() + "\n" + "  CONNECT TO " + (this.checkCurrentUser.isSelected() ? "CURRENT_USER" : this.textConnectUser.getText() + " IDENTIFIED BY " + this.textConnectPassword.getText()) + (this.checkShared.isSelected() ? "\n  AUTHENTICATED BY " + SQLUtil.createSqlName((String)this.textSharedUser.getText()) + " IDENTIFIED BY " + this.textSharedPassword.getText() : "") + "\n" + "  USING '" + this.textHost.getText() + "'";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textName = new TextField();
        this.checkPublic = new JCheckBox();
        this.checkCurrentUser = new JCheckBox();
        this.labelConnectUser = new JLabel();
        this.textConnectUser = new TextField();
        this.labelConnectPassword = new JLabel();
        this.textConnectPassword = new TextField();
        this.jLabel4 = new JLabel();
        this.textHost = new TextField();
        this.checkShared = new JCheckBox();
        this.labelSharedUser = new JLabel();
        this.textSharedUser = new TextField();
        this.labelSharedPassword = new JLabel();
        this.textSharedPassword = new TextField();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("db-link-name-dd"));
        this.checkPublic.setText(this.stringManager.getString("public"));
        this.checkCurrentUser.setText(this.stringManager.getString("current-user-dd"));
        this.checkCurrentUser.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateDbLinkWizard.this.checkCurrentUserItemStateChanged(evt);
            }
        });
        this.labelConnectUser.setHorizontalAlignment(4);
        this.labelConnectUser.setText(this.stringManager.getString("user-dd"));
        this.labelConnectPassword.setHorizontalAlignment(4);
        this.labelConnectPassword.setText(this.stringManager.getString("password-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("destination-server-dd"));
        this.checkShared.setText(this.stringManager.getString("shared-connection"));
        this.checkShared.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateDbLinkWizard.this.checkSharedItemStateChanged(evt);
            }
        });
        this.labelSharedUser.setHorizontalAlignment(4);
        this.labelSharedUser.setText(this.stringManager.getString("user-dd"));
        this.labelSharedUser.setEnabled(false);
        this.textSharedUser.setEnabled(false);
        this.labelSharedPassword.setHorizontalAlignment(4);
        this.labelSharedPassword.setText(this.stringManager.getString("password-dd"));
        this.labelSharedPassword.setEnabled(false);
        this.textSharedPassword.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(119, 119, 119).addComponent(this.checkCurrentUser)).addGroup(layout.createSequentialGroup().addComponent(this.labelConnectUser, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textConnectUser, -1, 222, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkPublic).addComponent((Component)this.textName, -1, 222, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textHost, -1, 222, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelConnectPassword, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkShared).addComponent((Component)this.textConnectPassword, -1, 222, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.labelSharedUser, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSharedUser, -1, 222, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelSharedPassword, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSharedPassword, -1, 222, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCurrentUser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelConnectUser).addComponent((Component)this.textConnectUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelConnectPassword).addComponent((Component)this.textConnectPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkShared).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSharedUser).addComponent((Component)this.textSharedUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSharedPassword).addComponent((Component)this.textSharedPassword, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void checkSharedItemStateChanged(ItemEvent evt) {
        this.labelSharedUser.setEnabled(this.checkShared.isSelected());
        this.labelSharedPassword.setEnabled(this.checkShared.isSelected());
        this.textSharedUser.setEnabled(this.checkShared.isSelected());
        this.textSharedPassword.setEnabled(this.checkShared.isSelected());
    }

    private void checkCurrentUserItemStateChanged(ItemEvent evt) {
        this.labelConnectUser.setEnabled(!this.checkCurrentUser.isSelected());
        this.labelConnectPassword.setEnabled(!this.checkCurrentUser.isSelected());
        this.textConnectUser.setEnabled(!this.checkCurrentUser.isSelected());
        this.textConnectPassword.setEnabled(!this.checkCurrentUser.isSelected());
    }
}

