/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.wizards.FunctionParameterDefinitionWizard;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateFunctionWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private FunctionParameterDefinitionWizard parametrDefinition;
    private Template template;
    private JComboBox comboReturnType;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JTabbedPane tab;
    private TextField textDescription;
    private TextField textName;

    public CreateFunctionWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.parametrDefinition = new FunctionParameterDefinitionWizard(this.database);
        this.tab.addTab(this.parametrDefinition.getTabTitle(), (Component)((Object)this.parametrDefinition));
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(OracleTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(OracleTemplatesSettingsProvider.setFunction, "oracle-function"));
        this.parametrDefinition.wizardShow();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateFunctionWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateFunctionWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        if (this.template == null) {
            return "CREATE FUNCTION " + SQLUtil.createSqlName((String)this.schemaName) + "." + this.textName.getText() + " " + this.parametrDefinition.getSqlCode() + " RETURN " + ((JTextField)this.comboReturnType.getEditor().getEditorComponent()).getText() + " IS \n" + "-- " + this.textDescription.getText() + "\n" + "BEGIN\n" + "  NULL;\n" + "END;\n" + "/";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&parameters", this.parametrDefinition.getSqlCode());
        map.put("&description", this.textDescription.getText());
        map.put("&return", ((JTextField)this.comboReturnType.getEditor().getEditorComponent()).getText());
        map.put("&body", "  NULL;");
        return this.template.expand(map) + "\n/";
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.tab = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel4 = new JLabel();
        this.textDescription = new TextField();
        this.jLabel5 = new JLabel();
        this.comboReturnType = new JComboBox();
        this.tab.setFocusable(false);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("procedure-name-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("description-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("return-type-dd"));
        this.comboReturnType.setEditable(true);
        this.comboReturnType.setModel(new DefaultComboBoxModel<String>(new String[]{"BFILE", "BINARY_DOUBLE", "BINARY_FLOAT", "BLOB", "CHAR", "CHAR VARYING", "CLOB", "DATE", "DECIMAL", "DOUBLE PRECISION", "FLOAT", "INTEGER", "LONG", "LONG RAW", "LONG VARCHAR", "NATIONAL CHAR", "NATIONAL CHAR VARYING", "NUMBER", "NVARCHAR2", "RAW", "REAL", "ROWID", "UROWID", "SMALLINT", "TIMESTAMP", "VARCHAR", "VARCHAR2"}));
        this.comboReturnType.setSelectedIndex(26);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textName, -2, 222, -2).addComponent((Component)this.textDescription, -1, 410, Short.MAX_VALUE).addComponent(this.comboReturnType, -2, 220, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboReturnType, -2, -1, -2)).addContainerGap(168, Short.MAX_VALUE)));
        this.tab.addTab(this.stringManager.getString("basic"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 580, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }
}

