/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.oracle.gui.wizards.StorageOptionsWizard;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateIndexWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JComboBox comboColumnName;
    private JComboBox comboColumnOrder;
    private StorageOptionsWizard storageOptions;
    private JButton buttonAddRow;
    private JButton buttonRemoveRow;
    private JCheckBox checkParallel;
    private Action cmAddRow;
    private Action cmRemoveRow;
    private ComboBox comboIndextype;
    private JComboBox comboTables;
    private JComboBox comboType;
    private ButtonGroup group;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JRadioButton radioColumns;
    private JRadioButton radioExpression;
    private JTabbedPane tab;
    private Table tableColumns;
    private TextField textDegree;
    private TextField textExpression;
    private TextField textName;

    public CreateIndexWizard(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{this.stringManager.getString("CreateIndexWizard-index-columns"), this.stringManager.getString("CreateIndexWizard-order")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableColumns.setRowHeight(20);
        this.comboColumnName = new JComboBox();
        this.comboColumnOrder = new JComboBox<Object>(new DefaultComboBoxModel<Object>(new Object[]{"", "ASC", "DESC"}));
        TableColumn tc = this.tableColumns.getColumnModel().getColumn(0);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnName));
        tc = this.tableColumns.getColumnModel().getColumn(1);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnOrder));
        this.comboTables.addItemListener(new TableItemListener(){
            OracleTableInfo lastTable;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemChanged(OracleTableInfo info) {
                Query query = CreateIndexWizard.this.database.createQuery();
                try {
                    query.setSqlText(Sql.getColumnNameList());
                    query.paramByName("SCHEMA_NAME").setString(CreateIndexWizard.this.schemaName);
                    query.paramByName("TABLE_NAME").setString(CreateIndexWizard.this.tableName);
                    query.open();
                    CreateIndexWizard.this.comboColumnName.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                finally {
                    query.close();
                }
            }
        });
        this.storageOptions = new StorageOptionsWizard(this.database, "INDEX");
        this.tab.addTab(this.storageOptions.getTabTitle(), (Component)((Object)this.storageOptions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getIndextypeNameList());
            this.comboIndextype.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.storageOptions.wizardShow();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateIndexWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateIndexWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String fkColumns = "";
        if (this.radioColumns.isSelected()) {
            for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
                Object column = this.tableColumns.getValueAt(i, 0);
                Object columnOrder = this.tableColumns.getValueAt(i, 1);
                if (column == null) continue;
                if (!StringUtil.isEmpty((String)fkColumns)) {
                    fkColumns = fkColumns + ", ";
                }
                fkColumns = fkColumns + SQLUtil.createSqlName((String)column.toString());
                if (columnOrder == null || StringUtil.isEmpty((String)columnOrder.toString())) continue;
                fkColumns = fkColumns + " " + columnOrder.toString();
            }
        } else if (this.radioExpression.isSelected()) {
            fkColumns = this.textExpression.getText();
        }
        String storage = this.storageOptions.getSqlCode();
        return "CREATE " + this.comboType.getSelectedItem().toString() + " INDEX " + this.textName.getText() + " ON " + SQLUtil.createSqlName((String)this.comboTables.getSelectedItem().toString()) + "(" + fkColumns + ")" + (this.checkParallel.isSelected() ? "\n PARALLEL " + this.textDegree.getText() : "") + (!StringUtil.isEmpty((String)this.comboIndextype.getText()) ? "\n INDEXTYPE IS " + this.comboIndextype.getText() : "") + (!StringUtil.isEmpty((String)storage) ? "\n" + storage : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.group = new ButtonGroup();
        this.tab = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.comboTables = new JComboBox();
        this.textDegree = new TextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new Table();
        this.radioColumns = new JRadioButton();
        this.buttonAddRow = new JButton();
        this.radioExpression = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.comboType = new JComboBox();
        this.buttonRemoveRow = new JButton();
        this.textExpression = new TextField();
        this.checkParallel = new JCheckBox();
        this.textName = new TextField();
        this.jLabel5 = new JLabel();
        this.comboIndextype = new ComboBox();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmAddRow.setText(this.stringManager.getString("cmAdd-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateIndexWizard.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/remove8.gif"));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemove-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateIndexWizard.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.tab.setFocusable(false);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("index-kind-dd"));
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("index-name-dd"));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.group.add(this.radioColumns);
        this.radioColumns.setSelected(true);
        this.radioColumns.setText(this.stringManager.getString("columns"));
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.group.add(this.radioExpression);
        this.radioExpression.setText(this.stringManager.getString("expression"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("index-table-dd"));
        this.comboType.setModel(new DefaultComboBoxModel<String>(new String[]{"", "UNIQUE", "BITMAP"}));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.checkParallel.setText(this.stringManager.getString("parallel"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("index-type-dd"));
        this.comboIndextype.setEditable(true);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textExpression, -1, 402, Short.MAX_VALUE).addComponent(this.radioExpression).addComponent(this.radioColumns).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.checkParallel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDegree, -2, 102, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonRemoveRow, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonAddRow, GroupLayout.Alignment.LEADING, -1, 60, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboTables, GroupLayout.Alignment.TRAILING, 0, 257, Short.MAX_VALUE).addComponent(this.comboType, GroupLayout.Alignment.TRAILING, 0, 257, Short.MAX_VALUE).addComponent((Component)this.comboIndextype, GroupLayout.Alignment.TRAILING, -1, 257, Short.MAX_VALUE).addComponent((Component)this.textName, GroupLayout.Alignment.TRAILING, -1, 257, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboType, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.comboIndextype, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioColumns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioExpression))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textExpression, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkParallel).addComponent((Component)this.textDegree, -2, -1, -2)).addContainerGap(36, Short.MAX_VALUE)));
        this.tab.addTab(this.stringManager.getString("basic"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 427, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 383, Short.MAX_VALUE).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getRowCount() > 1) {
            this.tableColumns.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
            ((DefaultTableModel)this.tableColumns.getModel()).removeRow(this.tableColumns.getRowCount() - 1);
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 0) != null) {
            ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{null, null});
        }
    }
}

