/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateSequenceWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private JCheckBox checkCycle;
    private JCheckBox checkOrder;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private TextField textCacheSize;
    private TextField textInc;
    private TextField textMax;
    private TextField textMin;
    private TextField textName;
    private TextField textStart;

    public CreateSequenceWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.schemaName = this.schemaName == null ? OracleDbInfoProvider.getCurrentSchema(this.database) : this.schemaName;
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateSequenceWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateSequenceWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        return "CREATE SEQUENCE " + SQLUtil.createSqlName((String)this.schemaName) + "." + this.textName.getText() + "\n" + "  START WITH " + this.textStart.getText() + "\n" + "  INCREMENT BY " + this.textInc.getText() + "\n" + "  " + (StringUtil.isEmpty((String)this.textMin.getText()) ? "NOMINVALUE" : "MINVALUE " + this.textMin.getText()) + "\n" + "  " + (StringUtil.isEmpty((String)this.textMax.getText()) ? "NOMAXVALUE" : "MAXVALUE " + this.textMax.getText()) + "\n" + "  " + (StringUtil.isEmpty((String)this.textCacheSize.getText()) ? "NOCACHE" : "CACHE " + this.textCacheSize.getText()) + "\n" + "  " + (this.checkCycle.isSelected() ? "CYCLE" : "NOCYCLE") + "\n" + "  " + (this.checkOrder.isSelected() ? "ORDER" : "NOORDER");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textName = new TextField();
        this.jLabel2 = new JLabel();
        this.textStart = new TextField();
        this.jLabel3 = new JLabel();
        this.textMin = new TextField();
        this.textMax = new TextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.textCacheSize = new TextField();
        this.checkCycle = new JCheckBox();
        this.checkOrder = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.textInc = new TextField();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("sequence-name-dd"));
        this.textName.setText("_SEQ");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("start-at-dd"));
        this.textStart.setText("1");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("minimum-value-dd"));
        this.textMin.setText("1");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("maximum-value-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("buffer-size-dd"));
        this.checkCycle.setText(this.stringManager.getString("cycle"));
        this.checkOrder.setText(this.stringManager.getString("keep-order"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("change-by-dd"));
        this.textInc.setText("1");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 222, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel6, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textInc, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel4, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textMax, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textMin, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textStart, -2, 179, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.checkCycle).addComponent(this.checkOrder, -1, -1, Short.MAX_VALUE).addComponent((Component)this.textCacheSize, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textMin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textInc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textCacheSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCycle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkOrder).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

