/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleSchemaInfo;
import pl.mpak.orbada.oracle.gui.util.ObjectComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.SchemaComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.SchemaItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateSynonymWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private JCheckBox checkPublic;
    private JComboBox comboObjects;
    private JComboBox comboSchemas;
    private ButtonGroup groupObject;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JRadioButton radioBaseObject;
    private JRadioButton radioNamedObject;
    private TextField textName;
    private TextField textObjectName;

    public CreateSynonymWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboSchemas.setModel(new SchemaComboBoxModel(this.database));
        this.comboObjects.setModel(new ObjectComboBoxModel(this.database));
        this.comboSchemas.addItemListener(new SchemaItemListener(){

            public void itemChanged(OracleSchemaInfo info) {
                ((ObjectComboBoxModel)CreateSynonymWizard.this.comboObjects.getModel()).change(info.getName());
            }
        });
    }

    public void wizardShow() {
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).change();
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).select(this.schemaName, this.comboSchemas);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateSynonymWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateSynonymWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        return "CREATE" + (this.checkPublic.isSelected() ? " PUBLIC" : "") + " SYNONYM " + this.textName.getText() + " FOR " + (this.radioBaseObject.isSelected() ? SQLUtil.createSqlName((String)this.comboSchemas.getSelectedItem().toString(), (String)this.comboObjects.getSelectedItem().toString()) : "") + (this.radioNamedObject.isSelected() ? SQLUtil.createSqlName((String)this.comboSchemas.getSelectedItem().toString()) + "." + this.textObjectName.getText() : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.groupObject = new ButtonGroup();
        this.jLabel5 = new JLabel();
        this.textName = new TextField();
        this.checkPublic = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.comboSchemas = new JComboBox();
        this.comboObjects = new JComboBox();
        this.textObjectName = new TextField();
        this.radioBaseObject = new JRadioButton();
        this.radioNamedObject = new JRadioButton();
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("synonym-name-dd"));
        this.checkPublic.setText(this.stringManager.getString("public"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("object-schema-dd"));
        this.comboSchemas.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateSynonymWizard.this.comboSchemasItemStateChanged(evt);
            }
        });
        this.comboObjects.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateSynonymWizard.this.comboObjectsItemStateChanged(evt);
            }
        });
        this.groupObject.add(this.radioBaseObject);
        this.radioBaseObject.setText(this.stringManager.getString("base-object"));
        this.radioBaseObject.setHorizontalAlignment(4);
        this.radioBaseObject.setHorizontalTextPosition(2);
        this.groupObject.add(this.radioNamedObject);
        this.radioNamedObject.setSelected(true);
        this.radioNamedObject.setText(this.stringManager.getString("object-name"));
        this.radioNamedObject.setHorizontalAlignment(4);
        this.radioNamedObject.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkPublic).addComponent((Component)this.textName, -1, 204, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.radioNamedObject, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.radioBaseObject, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING, -1, 127, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textObjectName, -1, 204, Short.MAX_VALUE).addComponent(this.comboObjects, 0, 204, Short.MAX_VALUE).addComponent(this.comboSchemas, 0, 204, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboSchemas, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioBaseObject).addComponent(this.comboObjects, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioNamedObject).addComponent((Component)this.textObjectName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void comboSchemasItemStateChanged(ItemEvent evt) {
    }

    private void comboObjectsItemStateChanged(ItemEvent evt) {
    }
}

