/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.DirectoryComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropDirectoryWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String directoryName;
    private JComboBox comboDirectory;
    private JLabel jLabel2;

    public DropDirectoryWizard(Database database, String directoryName) {
        this.database = database;
        this.directoryName = directoryName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboDirectory.setModel(new DirectoryComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((DirectoryComboBoxModel)this.comboDirectory.getModel()).change();
        ((DirectoryComboBoxModel)this.comboDirectory.getModel()).select(this.directoryName, this.comboDirectory);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("DropDirectoryWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("DropDirectoryWizard-tab-title");
    }

    public String getSqlCode() {
        return "DROP DIRECTORY " + SQLUtil.createSqlName((String)this.comboDirectory.getSelectedItem().toString());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboDirectory = new JComboBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("catalog-name-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboDirectory, 0, 196, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboDirectory, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

