/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.SynonymComboBoxModel;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropSynonymWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String sequenceName;
    private JComboBox comboSynonym;
    private JLabel jLabel8;

    public DropSynonymWizard(Database database, String schemaName, String sequenceName) {
        this.database = database;
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.schemaName = this.schemaName == null ? OracleDbInfoProvider.getCurrentSchema(this.database) : this.schemaName;
        this.comboSynonym.setModel(new SynonymComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((SynonymComboBoxModel)this.comboSynonym.getModel()).change(this.schemaName);
        ((SynonymComboBoxModel)this.comboSynonym.getModel()).select(this.sequenceName, this.comboSynonym);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("DropSynonymWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("DropSynonymWizard-tab-title");
    }

    public String getSqlCode() {
        return "DROP SYNONYM " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboSynonym.getSelectedItem().toString());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel8 = new JLabel();
        this.comboSynonym = new JComboBox();
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("synonym-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSynonym, 0, 233, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.comboSynonym, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

