/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.TriggerComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropTriggerWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String triggerName;
    private JComboBox comboTriggers;
    private JLabel jLabel3;

    public DropTriggerWizard(Database database, String schemaName, String triggerName) {
        this.database = database;
        this.schemaName = schemaName;
        this.triggerName = triggerName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTriggers.setModel(new TriggerComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((TriggerComboBoxModel)this.comboTriggers.getModel()).change(this.schemaName, null, null);
        ((TriggerComboBoxModel)this.comboTriggers.getModel()).select(this.triggerName, this.comboTriggers);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("DropTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("DropTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        return "DROP TRIGGER " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTriggers.getSelectedItem().toString());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.comboTriggers = new JComboBox();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("Trigger-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTriggers, 0, 196, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboTriggers, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

