/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.Sql;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.dbinfo.OracleTriggerInfo;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.oracle.gui.util.TriggerComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TriggerItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class EnableTriggerWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String objectName;
    private String triggerName;
    private ComboBox comboState;
    private JComboBox comboTables;
    private JComboBox comboTriggers;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    public EnableTriggerWizard(Database database, String schemaName, String objectName, String triggerName) {
        this.database = database;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.triggerName = triggerName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTriggers.setModel(new TriggerComboBoxModel(this.database));
        this.comboTriggers.addItemListener(new TriggerItemListener(){

            public void itemChanged(OracleTriggerInfo info) {
                EnableTriggerWizard.this.comboState.setText(EnableTriggerWizard.this.getStatus(EnableTriggerWizard.this.schemaName, info.getName()));
            }
        });
        if (this.objectName != null) {
            this.comboTables.setModel(new TableComboBoxModel(this.database));
            this.comboTables.addItemListener(new TableItemListener(){

                public void itemChanged(OracleTableInfo info) {
                    ((TriggerComboBoxModel)EnableTriggerWizard.this.comboTriggers.getModel()).change(info.getSchema().getName(), info.getName(), "TABLE");
                }
            });
        } else {
            this.comboTables.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatus(String schemaName, String triggerName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTriggerStatus());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TRIGGER_NAME").setString(triggerName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("nstatus").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    public void wizardShow() {
        if (this.objectName != null) {
            ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
            ((TableComboBoxModel)this.comboTables.getModel()).select(this.objectName, this.comboTables);
        } else {
            ((TriggerComboBoxModel)this.comboTriggers.getModel()).change(this.schemaName, null, null);
        }
        ((TriggerComboBoxModel)this.comboTriggers.getModel()).select(this.triggerName, this.comboTriggers);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("EnableTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("EnableTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TRIGGER " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTriggers.getSelectedItem().toString()) + " " + this.comboState.getSelectedItem().toString();
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboTriggers = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboState = new ComboBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("state-dd"));
        this.comboState.setModel(new DefaultComboBoxModel<String>(new String[]{"ENABLE", "DISABLE"}));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 189, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTriggers, 0, 189, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboState, -1, 189, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboTriggers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboState, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap(36, Short.MAX_VALUE)));
    }
}

