/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleRecyclebinInfo;
import pl.mpak.orbada.oracle.gui.util.RecyclebinComboBoxModel;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class FlashbackObjectWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String objectName;
    private String schemaName;
    private JComboBox comboObjects;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textRename;

    public FlashbackObjectWizard(Database database, String schemaName, String objectName) {
        this.database = database;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.initComponents();
        this.init();
    }

    public FlashbackObjectWizard(Database database, String objectName) {
        this(database, null, objectName);
    }

    private void init() {
        this.schemaName = this.schemaName == null ? OracleDbInfoProvider.getCurrentSchema(this.database) : this.schemaName;
        this.comboObjects.setModel(new RecyclebinComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((RecyclebinComboBoxModel)this.comboObjects.getModel()).change();
        ((RecyclebinComboBoxModel)this.comboObjects.getModel()).select(this.objectName, this.comboObjects);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("FlashbackObjectWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("FlashbackObjectWizard-tab-title");
    }

    public String getSqlCode() {
        OracleRecyclebinInfo info = (OracleRecyclebinInfo)((Object)this.comboObjects.getSelectedItem());
        if (info != null) {
            return "FLASHBACK " + info.getType() + " " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboObjects.getSelectedItem().toString()) + " TO BEFORE " + info.getOperation() + (!StringUtil.isEmpty((String)this.textRename.getText()) ? " RENAME TO " + this.textRename.getText() : "");
        }
        return "";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboObjects = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textRename = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("object-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("change-name-to-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboObjects, 0, 196, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textRename, -1, 196, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboObjects, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textRename, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

