/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PurgeRecyclebinWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private JCheckBox checkPurge;

    public PurgeRecyclebinWizard(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.schemaName = OracleDbInfoProvider.getCurrentSchema(this.database);
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("PurgeRecyclebinWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("PurgeRecyclebinWizard-tab-title");
    }

    public String getSqlCode() {
        if (this.checkPurge.isSelected()) {
            return "PURGE RECYCLEBIN";
        }
        return "";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.checkPurge = new JCheckBox();
        this.checkPurge.setText(this.stringManager.getString("purge-recyclebin"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkPurge).addContainerGap(252, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkPurge).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

