/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleTableInfo;
import pl.mpak.orbada.oracle.gui.util.TableComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableIndexComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TableItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RenameIndexWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private String indexName;
    private JComboBox comboIndexes;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private TextField textName;

    public RenameIndexWizard(Database database, String schemaName, String tableName, String indexName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.indexName = indexName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboIndexes.setModel(new TableIndexComboBoxModel(this.database));
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboTables.addItemListener(new TableItemListener(){

            public void itemChanged(OracleTableInfo info) {
                ((TableIndexComboBoxModel)RenameIndexWizard.this.comboIndexes.getModel()).change(info.getSchema().getName(), info.getName());
            }
        });
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
        ((TableIndexComboBoxModel)this.comboIndexes.getModel()).select(this.indexName, this.comboIndexes);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("RenameIndexWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("RenameIndexWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER INDEX " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboIndexes.getSelectedItem().toString()) + " RENAME TO " + this.textName.getText();
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboIndexes = new JComboBox();
        this.jLabel4 = new JLabel();
        this.textName = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("index-list-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("index-name-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 197, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboIndexes, 0, 197, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 197, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboIndexes, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

