/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleTypeInfo;
import pl.mpak.orbada.oracle.gui.util.SchemaComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TypeComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.TypeItemListener;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RevokeTypePrivilegesWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String objectName;
    private static String[] privileges = new String[]{"EXECUTE", "DEBUG"};
    private JButton buttonMoveAllRight;
    private JButton buttonMoveAllRight1;
    private JButton buttonMoveRight;
    private JButton buttonMoveRight1;
    private JCheckBox checkAll;
    private Action cmMoveAllLeft;
    private Action cmMoveAllRight;
    private Action cmMoveLeft;
    private Action cmMoveRight;
    private JComboBox comboObject;
    private JComboBox comboSchemas;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelAvailPrivs;
    private JLabel labelSelectedPrivs;
    private JList listAvailPrivs;
    private JList listSelectedPrivs;

    public RevokeTypePrivilegesWizard(Database database, String schemaName, String objectName) {
        this.database = database;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.listAvailPrivs.setModel(new DefaultListModel());
        this.listSelectedPrivs.setModel(new DefaultListModel());
        this.comboObject.setModel(new TypeComboBoxModel(this.database));
        this.comboObject.addItemListener(new TypeItemListener(){

            public void itemChanged(OracleTypeInfo info) {
                RevokeTypePrivilegesWizard.this.updateEventList(info);
            }
        });
        this.comboSchemas.setModel(new SchemaComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((TypeComboBoxModel)this.comboObject.getModel()).change(this.schemaName);
        ((TypeComboBoxModel)this.comboObject.getModel()).select(this.objectName, this.comboObject);
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).change();
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).select(this.schemaName, this.comboSchemas);
    }

    private void updateMoveActions() {
        this.cmMoveRight.setEnabled(this.listAvailPrivs.getSelectedValue() != null && !this.checkAll.isSelected());
        this.cmMoveAllRight.setEnabled(this.listAvailPrivs.getModel().getSize() > 0 && !this.checkAll.isSelected());
        this.cmMoveLeft.setEnabled(this.listSelectedPrivs.getSelectedValue() != null && !this.checkAll.isSelected());
        this.cmMoveAllLeft.setEnabled(this.listSelectedPrivs.getModel().getSize() > 0 && !this.checkAll.isSelected());
    }

    private void updateEventList(OracleTypeInfo info) {
        DefaultListModel model = (DefaultListModel)this.listSelectedPrivs.getModel();
        model.removeAllElements();
        model = (DefaultListModel)this.listAvailPrivs.getModel();
        model.removeAllElements();
        for (String s : privileges) {
            model.addElement(s);
        }
        this.updateMoveActions();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("RevokeTypePrivilegesWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("RevokeTypePrivilegesWizard-tab-title");
    }

    public String getSqlCode() {
        String privs = "";
        if (!this.checkAll.isSelected()) {
            DefaultListModel sel = (DefaultListModel)this.listSelectedPrivs.getModel();
            if (sel.getSize() > 0) {
                for (int i = 0; i < sel.getSize(); ++i) {
                    if (i > 0) {
                        privs = privs + ", ";
                    }
                    privs = privs + sel.getElementAt(i);
                }
            }
        } else {
            privs = "ALL";
        }
        return "REVOKE " + privs + " ON " + SQLUtil.createSqlName((String)this.comboObject.getSelectedItem().toString()) + " FROM " + SQLUtil.createSqlName((String)this.comboSchemas.getSelectedItem().toString());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmMoveRight = new Action();
        this.cmMoveAllRight = new Action();
        this.cmMoveLeft = new Action();
        this.cmMoveAllLeft = new Action();
        this.jLabel5 = new JLabel();
        this.comboObject = new JComboBox();
        this.labelAvailPrivs = new JLabel();
        this.jLabel6 = new JLabel();
        this.comboSchemas = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.listAvailPrivs = new JList();
        this.buttonMoveRight = new JButton();
        this.buttonMoveAllRight = new JButton();
        this.buttonMoveRight1 = new JButton();
        this.buttonMoveAllRight1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.listSelectedPrivs = new JList();
        this.labelSelectedPrivs = new JLabel();
        this.checkAll = new JCheckBox();
        this.cmMoveRight.setActionCommandKey("cmMoveRight");
        this.cmMoveRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_right.gif"));
        this.cmMoveRight.setText(this.stringManager.getString("cmMoveRight-text"));
        this.cmMoveRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RevokeTypePrivilegesWizard.this.cmMoveRightActionPerformed(evt);
            }
        });
        this.cmMoveAllRight.setActionCommandKey("cmMoveAllRight");
        this.cmMoveAllRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_all_right.gif"));
        this.cmMoveAllRight.setText(this.stringManager.getString("cmMoveAllRight-text"));
        this.cmMoveAllRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RevokeTypePrivilegesWizard.this.cmMoveAllRightActionPerformed(evt);
            }
        });
        this.cmMoveLeft.setActionCommandKey("cmMoveLeft");
        this.cmMoveLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_left.gif"));
        this.cmMoveLeft.setText(this.stringManager.getString("cmMoveLeft-text"));
        this.cmMoveLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RevokeTypePrivilegesWizard.this.cmMoveLeftActionPerformed(evt);
            }
        });
        this.cmMoveAllLeft.setActionCommandKey("cmMoveAllLeft");
        this.cmMoveAllLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_all_left.gif"));
        this.cmMoveAllLeft.setText(this.stringManager.getString("cmMoveAllLeft-text"));
        this.cmMoveAllLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RevokeTypePrivilegesWizard.this.cmMoveAllLeftActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("privilege-to-object-dd"));
        this.labelAvailPrivs.setText(this.stringManager.getString("granted-privileges-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("from-schema-dd"));
        this.listAvailPrivs.setSelectionMode(0);
        this.listAvailPrivs.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RevokeTypePrivilegesWizard.this.listAvailPrivsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listAvailPrivs);
        this.buttonMoveRight.setAction((javax.swing.Action)this.cmMoveRight);
        this.buttonMoveRight.setHideActionText(true);
        this.buttonMoveRight.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveRight.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveAllRight.setAction((javax.swing.Action)this.cmMoveAllRight);
        this.buttonMoveAllRight.setHideActionText(true);
        this.buttonMoveAllRight.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveAllRight.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveRight1.setAction((javax.swing.Action)this.cmMoveLeft);
        this.buttonMoveRight1.setHideActionText(true);
        this.buttonMoveRight1.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveRight1.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveAllRight1.setAction((javax.swing.Action)this.cmMoveAllLeft);
        this.buttonMoveAllRight1.setHideActionText(true);
        this.buttonMoveAllRight1.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveAllRight1.setPreferredSize(new Dimension(50, 23));
        this.listSelectedPrivs.setSelectionMode(0);
        this.listSelectedPrivs.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RevokeTypePrivilegesWizard.this.listSelectedPrivsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listSelectedPrivs);
        this.labelSelectedPrivs.setText(this.stringManager.getString("revoke-privileges-dd"));
        this.checkAll.setText(this.stringManager.getString("all"));
        this.checkAll.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RevokeTypePrivilegesWizard.this.checkAllItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAll).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboObject, 0, 235, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSchemas, 0, 235, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 157, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonMoveAllRight1, -2, 38, -2).addComponent(this.buttonMoveRight1, -2, 38, -2).addComponent(this.buttonMoveAllRight, -2, 38, -2).addComponent(this.buttonMoveRight, -2, 38, -2))).addComponent(this.labelAvailPrivs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSelectedPrivs).addComponent(this.jScrollPane2, -1, 159, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboObject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboSchemas, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSelectedPrivs).addComponent(this.labelAvailPrivs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 200, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 200, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.buttonMoveRight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveAllRight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveRight1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveAllRight1, -2, -1, -2))).addContainerGap()));
    }

    private void listAvailPrivsValueChanged(ListSelectionEvent evt) {
        this.updateMoveActions();
    }

    private void listSelectedPrivsValueChanged(ListSelectionEvent evt) {
        this.updateMoveActions();
    }

    private void cmMoveRightActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedPrivs.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailPrivs.getModel();
        sel.addElement(this.listAvailPrivs.getSelectedValue());
        tab.removeElement(this.listAvailPrivs.getSelectedValue());
        this.updateMoveActions();
    }

    private void cmMoveLeftActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedPrivs.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailPrivs.getModel();
        tab.addElement(this.listSelectedPrivs.getSelectedValue());
        sel.removeElement(this.listSelectedPrivs.getSelectedValue());
        this.updateMoveActions();
    }

    private void cmMoveAllRightActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedPrivs.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailPrivs.getModel();
        for (int i = 0; i < tab.getSize(); ++i) {
            sel.addElement(tab.get(i));
        }
        tab.removeAllElements();
        this.updateMoveActions();
    }

    private void cmMoveAllLeftActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedPrivs.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailPrivs.getModel();
        for (int i = 0; i < sel.getSize(); ++i) {
            tab.addElement(sel.get(i));
        }
        sel.removeAllElements();
        this.updateMoveActions();
    }

    private void checkAllItemStateChanged(ItemEvent evt) {
        this.labelAvailPrivs.setEnabled(!this.checkAll.isSelected());
        this.listAvailPrivs.setEnabled(!this.checkAll.isSelected());
        this.labelSelectedPrivs.setEnabled(!this.checkAll.isSelected());
        this.listSelectedPrivs.setEnabled(!this.checkAll.isSelected());
        this.updateMoveActions();
    }
}

