/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class TableColumnDefinitionWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String tableType;
    private int columnCount = 0;
    private JButton buttonAddRow;
    private JButton buttonMoveDown;
    private JButton buttonMoveUp;
    private JButton buttonRemoveRow;
    private Action cmAddRow;
    private Action cmMoveDown;
    private Action cmMoveUp;
    private Action cmRemoveRow;
    private JComboBox comboDataTypes;
    private JComboBox comboDefaultValue;
    private JScrollPane jScrollPane1;
    private Table tableColumns;

    public TableColumnDefinitionWizard(Database database, String tableType) {
        this.database = database;
        this.tableType = tableType;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.setRowHeight(20);
        ++this.columnCount;
        if ("EXTERNAL".equals(this.tableType)) {
            this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{"COLUMNA_1", "VARCHAR2(4000)"}}, new String[]{this.stringManager.getString("column-name"), this.stringManager.getString("type-and-size")}){
                Class[] types;
                {
                    this.types = new Class[]{String.class, String.class, Boolean.class, String.class};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }
            });
            this.tableColumns.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboDataTypes));
            this.tableColumns.getColumnModel().getColumn(0).setPreferredWidth(100);
            this.tableColumns.getColumnModel().getColumn(1).setPreferredWidth(150);
        } else {
            this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{"COLUMNA_1", "VARCHAR2(4000)", new Boolean(true), new Boolean(false), null, null}}, new String[]{this.stringManager.getString("column-name"), this.stringManager.getString("type-and-size"), this.stringManager.getString("is-not-null"), this.stringManager.getString("pk"), this.stringManager.getString("default-value"), this.stringManager.getString("comment")}){
                Class[] types;
                {
                    this.types = new Class[]{String.class, String.class, Boolean.class, Boolean.class, String.class, String.class};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }
            });
            this.tableColumns.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboDataTypes));
            this.tableColumns.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.comboDefaultValue));
            this.tableColumns.getColumnModel().getColumn(0).setPreferredWidth(100);
            this.tableColumns.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.tableColumns.getColumnModel().getColumn(2).setPreferredWidth(50);
            this.tableColumns.getColumnModel().getColumn(3).setPreferredWidth(50);
            this.tableColumns.getColumnModel().getColumn(4).setPreferredWidth(150);
            this.tableColumns.getColumnModel().getColumn(5).setPreferredWidth(300);
        }
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("TableColumnDefinitionWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("TableColumnDefinitionWizard-tab-title");
    }

    public String getSqlCode() {
        StringBuffer columns = new StringBuffer();
        if ("EXTERNAL".equals(this.tableType)) {
            for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
                Object name = this.tableColumns.getValueAt(i, 0);
                Object dataType = this.tableColumns.getValueAt(i, 1);
                if (name == null || dataType == null) continue;
                if (columns.length() > 0) {
                    columns.append(",\n");
                }
                columns.append("  " + name);
                columns.append(" " + dataType);
            }
        } else {
            for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
                Object name = this.tableColumns.getValueAt(i, 0);
                Object dataType = this.tableColumns.getValueAt(i, 1);
                Object notNullValue = this.tableColumns.getValueAt(i, 2);
                Object defaultValue = this.tableColumns.getValueAt(i, 4);
                if (name == null || dataType == null) continue;
                if (columns.length() > 0) {
                    columns.append(",\n");
                }
                columns.append("  " + name);
                columns.append(" " + dataType);
                if (defaultValue != null && !StringUtil.isEmpty((String)defaultValue.toString())) {
                    columns.append(" DEFAULT " + defaultValue.toString());
                }
                if (notNullValue == null || !((Boolean)notNullValue).booleanValue()) continue;
                columns.append(" NOT NULL");
            }
        }
        return columns.toString();
    }

    public String getSqlCodeComments(String schemaName, String tableName) {
        if ("EXTERNAL".equals(this.tableType)) {
            return "";
        }
        StringBuffer comments = new StringBuffer();
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object name = this.tableColumns.getValueAt(i, 0);
            Object comment = this.tableColumns.getValueAt(i, 5);
            if (name == null || comment == null || StringUtil.isEmpty((String)comment.toString())) continue;
            if (comments.length() > 0) {
                comments.append("\n");
            }
            comments.append("COMMENT ON COLUMN " + SQLUtil.createSqlName((String)schemaName) + "." + tableName + "." + name + " IS '" + comment.toString() + "'\n/");
        }
        return comments.toString();
    }

    public String getSqlCodePk(String schemaName, String tableName) {
        if ("EXTERNAL".equals(this.tableType)) {
            return "";
        }
        StringBuffer pks = new StringBuffer();
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object name = this.tableColumns.getValueAt(i, 0);
            Object pk = this.tableColumns.getValueAt(i, 3);
            if (name == null || pk == null || !((Boolean)pk).booleanValue()) continue;
            if (pks.length() > 0) {
                pks.append(", ");
            }
            pks.append(name);
        }
        if (pks.length() > 0) {
            return "ALTER TABLE " + SQLUtil.createSqlName((String)schemaName) + "." + tableName + " ADD CONSTRAINT " + tableName + "_PK PRIMARY KEY (" + pks.toString() + ")\n/";
        }
        return "";
    }

    public boolean execute() {
        return false;
    }

    private void cancelEdit() {
        this.tableColumns.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
        this.tableColumns.getColumnModel().getColumn(4).getCellEditor().cancelCellEditing();
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.cmMoveDown = new Action();
        this.cmMoveUp = new Action();
        this.comboDataTypes = new JComboBox();
        this.comboDefaultValue = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new Table();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.buttonMoveUp = new JButton();
        this.buttonMoveDown = new JButton();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmAddRow.setText(this.stringManager.getString("cmAdd-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnDefinitionWizard.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/remove8.gif"));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemove-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnDefinitionWizard.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.cmMoveDown.setActionCommandKey("cmMoveDown");
        this.cmMoveDown.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/down10.gif"));
        this.cmMoveDown.setText(this.stringManager.getString("cmDown-text"));
        this.cmMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnDefinitionWizard.this.cmMoveDownActionPerformed(evt);
            }
        });
        this.cmMoveUp.setActionCommandKey("cmMoveUp");
        this.cmMoveUp.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/up10.gif"));
        this.cmMoveUp.setText(this.stringManager.getString("cmUp-text"));
        this.cmMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableColumnDefinitionWizard.this.cmMoveUpActionPerformed(evt);
            }
        });
        this.comboDataTypes.setEditable(true);
        this.comboDataTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"BFILE", "BINARY_DOUBLE", "BINARY_FLOAT", "BLOB", "CHAR (size [|BYTE|CHAR])", "CHAR VARYING (size [|BYTE|CHAR])", "CLOB", "DATE", "DECIMAL (precision, scale)", "DOUBLE PRECISION", "FLOAT (precision)", "INTEGER", "INTERVAL DAY (day_precision) TO SECOND (fractional_precision)", "INTERVAL YEAR (precision) TO MONTH", "LONG", "LONG RAW", "LONG VARCHAR", "NATIONAL CHAR (size)", "NATIONAL CHAR VARYING (size)", "NUMBER (precision, scale)", "NVARCHAR2 (size)", "RAW (size)", "REAL", "ROWID", "UROWID (size)", "SMALLINT", "TIMESTAMP [(precision)] [|WITH TIME ZONE|WITH LOCAL TIME ZONE]", "VARCHAR (size [|BYTE|CHAR])", "VARCHAR2 (size [|BYTE|CHAR])"}));
        this.comboDefaultValue.setEditable(true);
        this.comboDefaultValue.setModel(new DefaultComboBoxModel<String>(new String[]{"", "SYSDATE", "USER"}));
        this.setPreferredSize(new Dimension(600, 300));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.tableColumns.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveUp.setAction((javax.swing.Action)this.cmMoveUp);
        this.buttonMoveUp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveDown.setAction((javax.swing.Action)this.cmMoveDown);
        this.buttonMoveDown.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 499, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonMoveUp, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonRemoveRow, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonAddRow, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonMoveDown, -1, 75, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveDown))).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getRowCount() > 1 && this.tableColumns.getSelectedRow() >= 0) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableColumns.getModel()).removeRow(this.tableColumns.getSelectedRow());
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 0) != null) {
            ++this.columnCount;
            if ("EXTERNAL".equals(this.tableType)) {
                ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{"COLUMNA_" + this.columnCount, "VARCHAR2(4000)"});
            } else {
                ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{"COLUMNA_" + this.columnCount, "VARCHAR2(4000)", new Boolean(true), new Boolean(false), null, null});
            }
            this.tableColumns.changeSelection(this.tableColumns.getRowCount() - 1, this.tableColumns.getRowCount() - 1);
        }
    }

    private void cmMoveDownActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() >= 0 && this.tableColumns.getSelectedRow() < this.tableColumns.getRowCount() - 1) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableColumns.getModel()).moveRow(this.tableColumns.getSelectedRow(), this.tableColumns.getSelectedRow(), this.tableColumns.getSelectedRow() + 1);
            this.tableColumns.changeSelection(this.tableColumns.getSelectedRow() + 1, this.tableColumns.getSelectedRow() + 1);
        }
    }

    private void cmMoveUpActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getSelectedRow() > 0) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableColumns.getModel()).moveRow(this.tableColumns.getSelectedRow(), this.tableColumns.getSelectedRow(), this.tableColumns.getSelectedRow() - 1);
            this.tableColumns.changeSelection(this.tableColumns.getSelectedRow() - 1, this.tableColumns.getSelectedRow() - 1);
        }
    }
}

