/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.mview;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.MViewComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.SchemaComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CopyMViewAsTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String viewName;
    private JCheckBox checkData;
    private JComboBox comboSchemas;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private TextField textName;

    public CopyMViewAsTableWizard(Database database, String schemaName, String viewName) {
        this.database = database;
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboSchemas.setModel(new SchemaComboBoxModel(this.database));
        this.comboTables.setModel(new MViewComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).change();
        ((SchemaComboBoxModel)this.comboSchemas.getModel()).select(this.schemaName, this.comboSchemas);
        ((MViewComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((MViewComboBoxModel)this.comboTables.getModel()).select(this.viewName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CopyMViewAsTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CopyMViewAsTableWizard-tab-title");
    }

    public String getSqlCode() {
        return "CREATE TABLE " + SQLUtil.createSqlName((String)this.comboSchemas.getSelectedItem().toString()) + "." + this.textName.getText() + " AS\n" + "SELECT * FROM " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + (!this.checkData.isSelected() ? "\n WHERE 1 = 0" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel6 = new JLabel();
        this.comboSchemas = new JComboBox();
        this.checkData = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("view-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("new-table-name-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("new-table-schema-dd"));
        this.comboSchemas.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CopyMViewAsTableWizard.this.comboSchemasItemStateChanged(evt);
            }
        });
        this.checkData.setText(this.stringManager.getString("copy-data-also"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 203, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSchemas, 0, 203, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkData).addComponent((Component)this.textName, -1, 203, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboSchemas, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkData).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void comboSchemasItemStateChanged(ItemEvent evt) {
    }
}

