/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.mview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleMViewInfo;
import pl.mpak.orbada.oracle.gui.util.MViewColumnComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.MViewComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.MViewItemListener;
import pl.mpak.orbada.oracle.gui.util.TablespaceComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateMViewIndexWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String viewName;
    private JComboBox comboColumnName;
    private JComboBox comboColumnOrder;
    private JButton buttonAddRow;
    private JButton buttonRemoveRow;
    private JCheckBox checkParallel;
    private JCheckBox checkTablespace;
    private Action cmAddRow;
    private Action cmRemoveRow;
    private JComboBox comboTables;
    private JComboBox comboTablespaces;
    private JComboBox comboType;
    private ButtonGroup group;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JRadioButton radioColumns;
    private JRadioButton radioExpression;
    private Table tableColumns;
    private TextField textDegree;
    private TextField textExpression;
    private TextField textName;

    public CreateMViewIndexWizard(Database database, String schemaName, String viewName) {
        this.database = database;
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.setRowHeight(20);
        this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{this.stringManager.getString("index-columns"), this.stringManager.getString("order")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.comboTablespaces.setModel(new TablespaceComboBoxModel(this.database));
        this.comboColumnName = new JComboBox(new MViewColumnComboBoxModel(this.database));
        this.comboColumnOrder = new JComboBox<Object>(new DefaultComboBoxModel<Object>(new Object[]{"", "ASC", "DESC"}));
        TableColumn tc = this.tableColumns.getColumnModel().getColumn(0);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnName));
        tc = this.tableColumns.getColumnModel().getColumn(1);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnOrder));
        this.comboTables.addItemListener(new MViewItemListener(){

            public void itemChanged(OracleMViewInfo info) {
                ((MViewColumnComboBoxModel)CreateMViewIndexWizard.this.comboColumnName.getModel()).change(info.getSchema().getName(), info.getName());
            }
        });
    }

    public void wizardShow() {
        ((TablespaceComboBoxModel)this.comboTablespaces.getModel()).change();
        ((MViewComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((MViewComboBoxModel)this.comboTables.getModel()).select(this.viewName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateMViewIndexWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateMViewIndexWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String fkColumns = "";
        if (this.radioColumns.isSelected()) {
            for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
                Object column = this.tableColumns.getValueAt(i, 0);
                Object columnOrder = this.tableColumns.getValueAt(i, 1);
                if (column == null) continue;
                if (!StringUtil.isEmpty((String)fkColumns)) {
                    fkColumns = fkColumns + ", ";
                }
                fkColumns = fkColumns + SQLUtil.createSqlName((String)column.toString());
                if (columnOrder == null || StringUtil.isEmpty((String)columnOrder.toString())) continue;
                fkColumns = fkColumns + " " + columnOrder.toString();
            }
        } else if (this.radioExpression.isSelected()) {
            fkColumns = this.textExpression.getText();
        }
        return "CREATE " + this.comboType.getSelectedItem().toString() + " INDEX " + this.textName.getText() + " ON " + SQLUtil.createSqlName((String)this.comboTables.getSelectedItem().toString()) + "(" + fkColumns + ")" + (this.checkParallel.isSelected() ? "\n PARALLEL " + this.textDegree.getText() : "") + (this.comboTablespaces.getSelectedItem() != null && this.checkTablespace.isSelected() ? "\n TABLESPACE " + SQLUtil.createSqlName((String)this.comboTablespaces.getSelectedItem().toString()) : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.group = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new Table();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.jLabel4 = new JLabel();
        this.comboType = new JComboBox();
        this.radioColumns = new JRadioButton();
        this.radioExpression = new JRadioButton();
        this.textExpression = new TextField();
        this.checkParallel = new JCheckBox();
        this.textDegree = new TextField();
        this.comboTablespaces = new JComboBox();
        this.checkTablespace = new JCheckBox();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmAddRow.setText(this.stringManager.getString("cmAdd-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateMViewIndexWizard.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/remove8.gif"));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemove-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateMViewIndexWizard.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("index-view-dd"));
        this.comboTables.setModel(new MViewComboBoxModel(this.database));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("index-name-dd"));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("index-type-dd"));
        this.comboType.setModel(new DefaultComboBoxModel<String>(new String[]{"", "UNIQUE", "BITMAP"}));
        this.group.add(this.radioColumns);
        this.radioColumns.setSelected(true);
        this.radioColumns.setText(this.stringManager.getString("columns"));
        this.group.add(this.radioExpression);
        this.radioExpression.setText(this.stringManager.getString("expression"));
        this.checkParallel.setText(this.stringManager.getString("parallel"));
        this.comboTablespaces.setModel(new DefaultComboBoxModel<String>(new String[]{"", "Unikalny", "Bitmapowy"}));
        this.checkTablespace.setText(this.stringManager.getString("tablespace-name"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textExpression, -1, 392, Short.MAX_VALUE).addComponent(this.radioExpression).addComponent(this.radioColumns).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonRemoveRow, -1, -1, Short.MAX_VALUE).addComponent(this.buttonAddRow, -2, 60, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.comboType, 0, 247, Short.MAX_VALUE).addComponent(this.comboTables, 0, 247, Short.MAX_VALUE).addComponent((Component)this.textName, GroupLayout.Alignment.LEADING, -1, 247, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.checkParallel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDegree, -2, 102, -2)).addGroup(layout.createSequentialGroup().addComponent(this.checkTablespace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTablespaces, 0, 275, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboType, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioColumns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow)).addComponent(this.jScrollPane1, -2, 103, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioExpression).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textExpression, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkParallel).addComponent((Component)this.textDegree, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkTablespace).addComponent(this.comboTablespaces, -2, 22, -2)).addContainerGap(24, Short.MAX_VALUE)));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getRowCount() > 1) {
            this.tableColumns.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
            ((DefaultTableModel)this.tableColumns.getModel()).removeRow(this.tableColumns.getRowCount() - 1);
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 0) != null) {
            ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{null, null});
        }
    }
}

