/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.mview;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dbinfo.OracleMViewInfo;
import pl.mpak.orbada.oracle.gui.util.MViewComboBoxModel;
import pl.mpak.orbada.oracle.gui.util.MViewItemListener;
import pl.mpak.orbada.oracle.gui.util.TriggerComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class EnableMViewTriggerWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String objectName;
    private String triggerName;
    private JComboBox comboState;
    private JComboBox comboTables;
    private JComboBox comboTriggers;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    public EnableMViewTriggerWizard(Database database, String schemaName, String objectName, String triggerName) {
        this.database = database;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.triggerName = triggerName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTriggers.setModel(new TriggerComboBoxModel(this.database));
        if (this.objectName != null) {
            this.comboTables.setModel(new MViewComboBoxModel(this.database));
            this.comboTables.addItemListener(new MViewItemListener(){

                public void itemChanged(OracleMViewInfo info) {
                    ((TriggerComboBoxModel)EnableMViewTriggerWizard.this.comboTriggers.getModel()).change(info.getSchema().getName(), info.getName(), "MATERIALIZED VIEW");
                }
            });
        } else {
            this.comboTables.setEnabled(false);
        }
    }

    public void wizardShow() {
        if (this.objectName != null) {
            ((MViewComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
            ((MViewComboBoxModel)this.comboTables.getModel()).select(this.objectName, this.comboTables);
        } else {
            ((TriggerComboBoxModel)this.comboTriggers.getModel()).change(this.schemaName, null, null);
        }
        ((TriggerComboBoxModel)this.comboTriggers.getModel()).select(this.triggerName, this.comboTriggers);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("EnableMViewTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("EnableMViewTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TRIGGER " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTriggers.getSelectedItem().toString()) + " " + this.comboState.getSelectedItem().toString();
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboTriggers = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboState = new JComboBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("view-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-list-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("state-dd"));
        this.comboState.setModel(new DefaultComboBoxModel<String>(new String[]{"ENABLE", "DISABLE"}));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 196, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTriggers, 0, 196, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboState, 0, 196, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboTriggers, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboState, -2, 22, -2)).addContainerGap(25, Short.MAX_VALUE)));
    }
}

