/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.mview;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.gui.util.MViewComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ShrinkMViewWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private String schemaName;
    private String viewName;
    private JCheckBox checkCascade;
    private JCheckBox checkCompact;
    private JComboBox comboTables;
    private JLabel jLabel2;

    public ShrinkMViewWizard(Database database, String schemaName, String viewName) {
        this.database = database;
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new MViewComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((MViewComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((MViewComboBoxModel)this.comboTables.getModel()).select(this.viewName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("ShrinkMViewWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("ShrinkMViewWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER MATERIALIZED VIEW " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + " SHRINK SPACE" + (this.checkCompact.isSelected() ? " COMPACT" : "") + (this.checkCascade.isSelected() ? " CASCADE" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.checkCompact = new JCheckBox();
        this.checkCascade = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("view-dd"));
        this.checkCompact.setText(this.stringManager.getString("compact"));
        this.checkCascade.setText(this.stringManager.getString("cascade"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkCascade).addComponent(this.checkCompact).addComponent(this.comboTables, 0, 196, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCompact).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCascade).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

