/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.parameters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class PlSqlWarningsWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private JCheckBox checkSystem;
    private JComboBox comboDetails;
    private JComboBox comboState;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private Table table;

    public PlSqlWarningsWizard(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.checkSystem.setEnabled(OracleDbInfoProvider.instance.getDatabaseInfo(this.database).getObjectInfo("/SESSION PRIVILEGES/ALTER SYSTEM") != null);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{this.stringManager.getString("state"), this.stringManager.getString("value")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.comboState));
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboDetails));
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("PlSqlWarningsWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("PlSqlWarningsWizard-tab-title");
    }

    public String getSqlCode() {
        String sets = "";
        for (int r = 0; r < this.table.getRowCount(); ++r) {
            Object state = this.table.getValueAt(r, 0);
            Object value = this.table.getValueAt(r, 1);
            if (state == null || value == null) continue;
            if (!StringUtil.isEmpty((String)sets)) {
                sets = sets + ", ";
            }
            sets = sets + "'" + state.toString() + ":" + value.toString() + "'";
        }
        return "ALTER " + (this.checkSystem.isSelected() ? "SYSTEM" : "SESSION") + " SET PLSQL_WARNINGS = " + sets;
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.comboState = new JComboBox();
        this.comboDetails = new JComboBox();
        this.jLabel3 = new JLabel();
        this.checkSystem = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new Table();
        this.comboState.setModel(new DefaultComboBoxModel<String>(new String[]{"ENABLE", "DISABLE", "ERROR"}));
        this.comboDetails.setEditable(true);
        this.comboDetails.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "SEVERE", "INFORMATIONAL", "PERFORMANCE", "integer", "(integer [, integer ] ...)"}));
        this.jLabel3.setText(this.stringManager.getString("plsql-warnings-dd"));
        this.checkSystem.setText(this.stringManager.getString("system"));
        this.table.setPreferredSize(new Dimension(150, 162));
        this.table.setRowHeight(20);
        this.jScrollPane1.setViewportView((Component)this.table);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 434, Short.MAX_VALUE).addComponent(this.checkSystem).addComponent(this.jLabel3)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 185, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSystem).addContainerGap()));
    }
}

