/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.gui.wizards.parameters;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.services.OracleDbInfoProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SqlTraceWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOraclePlugin.class);
    private Database database;
    private JCheckBox checkSystem;
    private JComboBox comboState;
    private JLabel jLabel3;

    public SqlTraceWizard(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.checkSystem.setEnabled(OracleDbInfoProvider.instance.getDatabaseInfo(this.database).getObjectInfo("/SESSION PRIVILEGES/ALTER SYSTEM") != null);
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("SqlTraceWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("SqlTraceWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER " + (this.checkSystem.isSelected() ? "SYSTEM" : "SESSION") + " SET SQL_TRACE = " + this.comboState.getSelectedItem().toString();
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.comboState = new JComboBox();
        this.checkSystem = new JCheckBox();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("sql-trace-dd"));
        this.comboState.setModel(new DefaultComboBoxModel<String>(new String[]{"TRUE", "FALSE"}));
        this.checkSystem.setText(this.stringManager.getString("system"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkSystem).addComponent(this.comboState, 0, 173, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboState, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSystem).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

